/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.markuputils;

import com.aventstack.extentreports.annotations.MarkupIgnore;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.markuputils.util.ReflectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

class Table
implements Markup {
    private static final long serialVersionUID = 7780527162407673294L;
    private String[][] data;
    private Object object;
    private String cssClass;
    private String[] cssClasses;

    @Override
    public String getMarkup() {
        if (this.cssClasses != null && this.cssClasses.length > 0) {
            Arrays.asList(this.cssClasses).forEach(x -> {
                this.cssClass = this.cssClass + " " + x;
            });
        }
        if (this.data != null) {
            return this.fromData();
        }
        try {
            return this.fromObject();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String fromData() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='markup-table table " + this.cssClass + "'>");
        for (int row = 0; row < this.data.length; ++row) {
            sb.append("<tr>");
            for (int col = 0; col < this.data[row].length; ++col) {
                sb.append("<td>" + this.data[row][col] + "</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String fromObject() throws IllegalArgumentException, IllegalAccessException {
        if (this.object == null) {
            return "";
        }
        List<Field> fieldList = ReflectionUtil.getFieldsIgnoringAnnotation(this.object.getClass(), MarkupIgnore.class);
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        sb.append("<table class='markup-table table " + this.cssClass + "'>");
        sb.append("<tbody>");
        List<String> list = Stream.of("").collect(Collectors.toList());
        List<Integer> columnRowCount = Stream.of(Integer.valueOf(0)).collect(Collectors.toList());
        if (this.object instanceof Map) {
            this.appendMapItems(this.object, list, sb2, columnRowCount);
        } else if (this.object instanceof List || this.object instanceof Set) {
            this.appendListItems(this.object, list, sb2, columnRowCount);
        } else if (this.object instanceof String) {
            list.set(0, "<td>" + this.object.toString() + "</td>");
        } else if (this.object.getClass().isArray()) {
            this.appendArrayItems(this.object, list, sb2, columnRowCount);
        } else if (!fieldList.isEmpty()) {
            sb.append("<thead><tr>");
            fieldList.forEach(x -> sb.append("<th>" + x.getName() + "</th>"));
            sb.append("</tr></thead>");
            for (Field f : fieldList) {
                if (f != null && !f.isAccessible()) {
                    f.setAccessible(true);
                }
                if (f.getType().isAssignableFrom(Map.class)) {
                    this.appendMapItems(f.get(this.object), list, sb2, columnRowCount);
                } else if (f.getType().isAssignableFrom(List.class) || f.getType().isAssignableFrom(Set.class)) {
                    this.appendListItems(f.get(this.object), list, sb2, columnRowCount);
                } else if (f.getType().isArray()) {
                    this.appendArrayItems(f.get(this.object), list, sb2, columnRowCount);
                } else {
                    list.set(0, list.get(0) + "<td>" + f.get(this.object).toString() + "</td>");
                    columnRowCount.set(columnRowCount.size() - 1, 1);
                }
                columnRowCount.add(0);
            }
        } else {
            list.set(0, "<td>" + this.object.toString() + "</td>");
        }
        list.forEach(x -> sb.append("<tr>" + x + "</tr>"));
        sb.append("</tbody>");
        sb.append("</table>");
        return sb.toString();
    }

    private void appendMapItems(Object object, List<String> list, StringBuilder sb, List<Integer> columnRowCount) {
        Map map = (Map)object;
        for (int ix = map.size(); ix >= list.size(); --ix) {
            list.add("");
        }
        columnRowCount.set(columnRowCount.size() - 1, map.size());
        int row = 0;
        for (Map.Entry entry : map.entrySet()) {
            sb.setLength(0);
            if (columnRowCount.size() > 1 && row + 1 > columnRowCount.get(columnRowCount.size() - 2)) {
                sb.append("<td></td>");
            }
            sb.append("<td>" + entry.getKey() + ":" + entry.getValue() + "</td>");
            list.set(row, list.get(row) + sb.toString());
            ++row;
        }
    }

    private void appendListItems(Object object, List<String> list, StringBuilder sb, List<Integer> columnRowCount) {
        int row = 0;
        Collection obj = (Collection)object;
        for (int ix = obj.size(); ix >= list.size(); --ix) {
            list.add("");
        }
        columnRowCount.set(columnRowCount.size() - 1, obj.size());
        for (Object o : obj) {
            sb.setLength(0);
            if (columnRowCount.size() > 1 && row + 1 > columnRowCount.get(columnRowCount.size() - 2)) {
                sb.append("<td></td>");
            }
            sb.append("<td>" + o.toString() + "</td>");
            list.set(row, list.get(row) + sb.toString());
            ++row;
        }
    }

    private void appendArrayItems(Object object, List<String> list, StringBuilder sb, List<Integer> columnRowCount) {
        Object[] array = this.toArray(object);
        List<Object> obj = Arrays.asList(array);
        this.appendListItems(obj, list, sb, columnRowCount);
    }

    private Object[] toArray(Object array) {
        Class<?> clz = array.getClass().getComponentType();
        if (clz.isPrimitive()) {
            int length = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
            return list.toArray();
        }
        return (Object[])array;
    }

    @Generated
    private static String $default$cssClass() {
        return "";
    }

    @Generated
    public static TableBuilder builder() {
        return new TableBuilder();
    }

    @Generated
    public String[][] getData() {
        return this.data;
    }

    @Generated
    public Object getObject() {
        return this.object;
    }

    @Generated
    public String getCssClass() {
        return this.cssClass;
    }

    @Generated
    public String[] getCssClasses() {
        return this.cssClasses;
    }

    @Generated
    public Table(String[][] data, Object object, String cssClass, String[] cssClasses) {
        this.data = data;
        this.object = object;
        this.cssClass = cssClass;
        this.cssClasses = cssClasses;
    }

    @Generated
    public String toString() {
        return "Table(data=" + Arrays.deepToString((Object[])this.getData()) + ", object=" + this.getObject() + ", cssClass=" + this.getCssClass() + ", cssClasses=" + Arrays.deepToString(this.getCssClasses()) + ")";
    }

    @Generated
    public static class TableBuilder {
        @Generated
        private String[][] data;
        @Generated
        private Object object;
        @Generated
        private boolean cssClass$set;
        @Generated
        private String cssClass$value;
        @Generated
        private String[] cssClasses;

        @Generated
        TableBuilder() {
        }

        @Generated
        public TableBuilder data(String[][] data) {
            this.data = data;
            return this;
        }

        @Generated
        public TableBuilder object(Object object) {
            this.object = object;
            return this;
        }

        @Generated
        public TableBuilder cssClass(String cssClass) {
            this.cssClass$value = cssClass;
            this.cssClass$set = true;
            return this;
        }

        @Generated
        public TableBuilder cssClasses(String[] cssClasses) {
            this.cssClasses = cssClasses;
            return this;
        }

        @Generated
        public Table build() {
            String cssClass$value = this.cssClass$value;
            if (!this.cssClass$set) {
                cssClass$value = Table.$default$cssClass();
            }
            return new Table(this.data, this.object, cssClass$value, this.cssClasses);
        }

        @Generated
        public String toString() {
            return "Table.TableBuilder(data=" + Arrays.deepToString((Object[])this.data) + ", object=" + this.object + ", cssClass$value=" + this.cssClass$value + ", cssClasses=" + Arrays.deepToString(this.cssClasses) + ")";
        }
    }
}

