/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component;

import com.axellience.vuegwt.core.annotations.component.Component;
import com.axellience.vuegwt.core.annotations.component.Computed;
import com.axellience.vuegwt.core.annotations.component.Data;
import com.axellience.vuegwt.core.annotations.component.Emit;
import com.axellience.vuegwt.core.annotations.component.HookMethod;
import com.axellience.vuegwt.core.annotations.component.Prop;
import com.axellience.vuegwt.core.annotations.component.PropDefault;
import com.axellience.vuegwt.core.annotations.component.PropValidator;
import com.axellience.vuegwt.core.annotations.component.Ref;
import com.axellience.vuegwt.core.annotations.component.Watch;
import com.axellience.vuegwt.core.client.VueGWT;
import com.axellience.vuegwt.core.client.component.hooks.HasCreated;
import com.axellience.vuegwt.core.client.component.hooks.HasRender;
import com.axellience.vuegwt.core.client.component.options.VueComponentOptions;
import com.axellience.vuegwt.core.client.component.options.computed.ComputedKind;
import com.axellience.vuegwt.core.client.component.options.watch.WatchOptions;
import com.axellience.vuegwt.core.client.tools.FieldsExposer;
import com.axellience.vuegwt.core.client.tools.VueGWTTools;
import com.axellience.vuegwt.core.client.vnode.VNode;
import com.axellience.vuegwt.core.client.vnode.builder.CreateElementFunction;
import com.axellience.vuegwt.core.client.vnode.builder.VNodeBuilder;
import com.axellience.vuegwt.processors.component.ComponentInjectedDependenciesBuilder;
import com.axellience.vuegwt.processors.component.ExposedField;
import com.axellience.vuegwt.processors.component.template.ComponentTemplateProcessor;
import com.axellience.vuegwt.processors.component.validators.CollectionFieldsValidator;
import com.axellience.vuegwt.processors.utils.ComponentGeneratorsUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import elemental2.core.Function;
import elemental2.core.JsArray;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import vuegwt.shaded.com.squareup.javapoet.AnnotationSpec;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.FieldSpec;
import vuegwt.shaded.com.squareup.javapoet.MethodSpec;
import vuegwt.shaded.com.squareup.javapoet.ParameterizedTypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeSpec;

public class ComponentExposedTypeGenerator {
    private static final String METHOD_IN_PROTO_PREFIX = "vg$e";
    private final ProcessingEnvironment processingEnv;
    private final Filer filer;
    private final Messager messager;
    private final Elements elements;
    private final ComponentTemplateProcessor componentTemplateProcessor;
    private final CollectionFieldsValidator collectionFieldsValidator;
    private TypeElement component;
    private TypeSpec.Builder componentExposedTypeBuilder;
    private MethodSpec.Builder optionsBuilder;
    private TypeSpec.Builder protoClassBuilder;
    private Set<VariableElement> fieldsToMarkAsData;
    private Set<ExposedField> fieldsWithNameExposed;
    private int methodsInProtoCount;

    public ComponentExposedTypeGenerator(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = processingEnvironment;
        this.filer = processingEnvironment.getFiler();
        this.messager = processingEnvironment.getMessager();
        this.elements = processingEnvironment.getElementUtils();
        this.componentTemplateProcessor = new ComponentTemplateProcessor(processingEnvironment);
        this.collectionFieldsValidator = new CollectionFieldsValidator(processingEnvironment.getTypeUtils(), this.elements, this.messager);
    }

    public void generate(TypeElement component, ComponentInjectedDependenciesBuilder dependenciesBuilder) {
        ClassName componentWithSuffixClassName = GeneratorsNameUtil.componentExposedTypeName(component);
        this.component = component;
        this.methodsInProtoCount = 0;
        this.fieldsToMarkAsData = new HashSet<VariableElement>();
        this.fieldsWithNameExposed = new HashSet<ExposedField>();
        this.componentExposedTypeBuilder = this.createComponentExposedTypeBuilder(componentWithSuffixClassName);
        this.protoClassBuilder = this.createProtoClassBuilder();
        this.optionsBuilder = this.createOptionsMethodBuilder();
        Set<ExecutableElement> hookMethodsFromInterfaces = this.getHookMethodsFromInterfaces();
        this.processData();
        this.processProps();
        this.processComputed();
        this.processPropValidators();
        this.processPropDefaultValues();
        this.processRefs();
        this.processHooks(hookMethodsFromInterfaces);
        this.processMethods(hookMethodsFromInterfaces);
        this.processEmitMethods();
        this.processRenderFunction();
        this.createCreatedHook(dependenciesBuilder);
        this.initComponentDataFields();
        if (ComponentGeneratorsUtil.hasTemplate(this.processingEnv, component)) {
            this.componentTemplateProcessor.processComponentTemplate(component, this);
            this.optionsBuilder.addStatement("options.initRenderFunctions(getRenderFunction(), getStaticRenderFunctions())", new Object[0]);
        }
        this.optionsBuilder.addStatement("return options", new Object[0]);
        this.componentExposedTypeBuilder.addMethod(this.optionsBuilder.build());
        this.componentExposedTypeBuilder.addType(this.protoClassBuilder.build());
        this.exposeExposedFieldsToJs();
        GeneratorsUtil.toJavaFile(this.filer, this.componentExposedTypeBuilder, componentWithSuffixClassName, component);
    }

    private TypeSpec.Builder createComponentExposedTypeBuilder(ClassName exposedTypeClassName) {
        return TypeSpec.classBuilder(exposedTypeClassName).addModifiers(Modifier.PUBLIC).superclass(TypeName.get(this.component.asType())).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", ComponentExposedTypeGenerator.class.getCanonicalName()).addMember("comments", "$S", "https://github.com/Axellience/vue-gwt").build());
    }

    private TypeSpec.Builder createProtoClassBuilder() {
        this.componentExposedTypeBuilder.addField(FieldSpec.builder(ClassName.bestGuess("Proto"), "__proto__", Modifier.PUBLIC).addAnnotation(JsProperty.class).build());
        return TypeSpec.classBuilder("Proto").addSuperinterface(ParameterizedTypeName.get(JsPropertyMap.class, new Type[]{Object.class})).addModifiers(Modifier.STATIC).addModifiers(Modifier.PRIVATE).addAnnotation(AnnotationSpec.builder(JsType.class).addMember("isNative", "$L", true).addMember("namespace", "$T.GLOBAL", JsPackage.class).addMember("name", "$S", "Object").build());
    }

    private MethodSpec.Builder createOptionsMethodBuilder() {
        ParameterizedTypeName optionsTypeName = ParameterizedTypeName.get(ClassName.get(VueComponentOptions.class), ClassName.get(this.component));
        MethodSpec.Builder optionsMethodBuilder = MethodSpec.methodBuilder("getOptions").addModifiers(Modifier.PUBLIC).returns(optionsTypeName).addStatement("$T options = new $T()", optionsTypeName, optionsTypeName).addStatement("Proto p = __proto__", new Object[0]);
        Component annotation = this.component.getAnnotation(Component.class);
        if (!"".equals(annotation.name())) {
            optionsMethodBuilder.addStatement("options.setName($S)", annotation.name());
        }
        optionsMethodBuilder.addStatement("options.setComponentExportedTypePrototype(p)", VueGWT.class, this.component);
        return optionsMethodBuilder;
    }

    private void processData() {
        List<VariableElement> dataFields = ElementFilter.fieldsIn(this.component.getEnclosedElements()).stream().filter(field -> field.getAnnotation(Data.class) != null).collect(Collectors.toList());
        if (dataFields.isEmpty()) {
            return;
        }
        dataFields.forEach(this.collectionFieldsValidator::validateComponentDataField);
        this.fieldsToMarkAsData.addAll(dataFields);
    }

    private void initComponentDataFields() {
        Component annotation = this.component.getAnnotation(Component.class);
        this.optionsBuilder.beginControlFlow("options.initData($L, $T.getFieldsName(this, () ->", annotation.useFactory(), VueGWTTools.class);
        this.fieldsToMarkAsData.forEach(field -> this.optionsBuilder.addStatement("this.$L = $L", field.getSimpleName().toString(), GeneratorsUtil.getFieldMarkingValueForType(field.asType())));
        this.optionsBuilder.endControlFlow("))", new Object[0]);
        this.fieldsWithNameExposed.addAll(this.fieldsToMarkAsData.stream().map(field -> new ExposedField(field.getSimpleName().toString(), field.asType())).collect(Collectors.toSet()));
    }

    private void exposeExposedFieldsToJs() {
        if (this.fieldsWithNameExposed.isEmpty()) {
            return;
        }
        MethodSpec.Builder exposeFieldMethod = MethodSpec.methodBuilder("vg$ef").addAnnotation(JsMethod.class);
        this.fieldsWithNameExposed.forEach(field -> exposeFieldMethod.addStatement("this.$L = $T.v()", field.getName(), FieldsExposer.class));
        exposeFieldMethod.addStatement("$T.e($L)", FieldsExposer.class, this.fieldsWithNameExposed.stream().map(ExposedField::getName).collect(Collectors.joining(",")));
        this.componentExposedTypeBuilder.addMethod(exposeFieldMethod.build());
    }

    private void processProps() {
        ElementFilter.fieldsIn(this.component.getEnclosedElements()).stream().filter(field -> GeneratorsUtil.hasAnnotation(field, Prop.class)).forEach(this::processProp);
    }

    private void processProp(VariableElement field) {
        String propName = field.getSimpleName().toString();
        Prop prop = field.getAnnotation(Prop.class);
        this.collectionFieldsValidator.validateComponentPropField(field);
        TypeMirror typeMirror = field.asType();
        TypeName typeName = TypeName.get(typeMirror);
        this.fieldsWithNameExposed.add(new ExposedField(propName, typeMirror));
        this.optionsBuilder.addStatement("options.addJavaProp($S, $T.getFieldName(this, () -> this.$L = $L), $L, $S)", propName, VueGWTTools.class, propName, GeneratorsUtil.getFieldMarkingValueForType(typeMirror), prop.required(), prop.checkType() ? this.getNativeNameForJavaType(typeName) : null);
        if (this.isBooleanObject(typeName)) {
            this.optionsBuilder.addStatement("options.addJavaPropDefaultValue($S, null)", propName);
        }
    }

    private void processComputed() {
        this.getMethodsWithAnnotation(this.component, Computed.class).forEach(method -> {
            ComputedKind kind = ComputedKind.GETTER;
            if ("void".equals(method.getReturnType().toString())) {
                kind = ComputedKind.SETTER;
            }
            String exposedMethodName = this.exposeExistingJavaMethodToJs((ExecutableElement)method);
            String fieldName = GeneratorsNameUtil.computedPropertyNameToFieldName(GeneratorsUtil.getComputedPropertyName(method));
            TypeMirror propertyType = this.getComputedPropertyTypeFromMethod((ExecutableElement)method);
            this.fieldsWithNameExposed.add(new ExposedField(fieldName, propertyType));
            this.optionsBuilder.addStatement("options.addJavaComputed(p.$L, $T.getFieldName(this, () -> this.$L = $L), $T.$L)", exposedMethodName, VueGWTTools.class, fieldName, GeneratorsUtil.getFieldMarkingValueForType(propertyType), ComputedKind.class, kind);
        });
        this.addFieldsForComputedMethod(this.component, new HashSet<String>());
    }

    private void processMethods(Set<ExecutableElement> hookMethodsFromInterfaces) {
        List<ExecutableElement> templateMethods = ElementFilter.methodsIn(this.component.getEnclosedElements()).stream().filter(ComponentGeneratorsUtil::isMethodVisibleInTemplate).filter(method -> !this.isHookMethod(this.component, (ExecutableElement)method, hookMethodsFromInterfaces)).collect(Collectors.toList());
        templateMethods.forEach(method -> {
            String methodName = method.getSimpleName().toString();
            String exposedMethodName = this.exposeExistingJavaMethodToJs((ExecutableElement)method);
            this.optionsBuilder.addStatement("options.addMethod($S, p.$L)", methodName, exposedMethodName);
        });
    }

    private void processEmitMethods() {
        ElementFilter.methodsIn(this.component.getEnclosedElements()).stream().filter(method -> GeneratorsUtil.hasAnnotation(method, Emit.class)).filter(method -> !GeneratorsUtil.hasAnnotation(method, JsMethod.class)).forEach(this::exposeExistingJavaMethodToJs);
    }

    private void addFieldsForComputedMethod(TypeElement component, Set<String> alreadyDone) {
        this.getMethodsWithAnnotation(component, Computed.class).forEach(method -> {
            String propertyName = GeneratorsNameUtil.computedPropertyNameToFieldName(GeneratorsUtil.getComputedPropertyName(method));
            if (alreadyDone.contains(propertyName)) {
                return;
            }
            TypeMirror propertyType = this.getComputedPropertyTypeFromMethod((ExecutableElement)method);
            this.componentExposedTypeBuilder.addField(FieldSpec.builder(TypeName.get(propertyType), propertyName, Modifier.PROTECTED).addAnnotation(JsProperty.class).build());
            alreadyDone.add(propertyName);
        });
        ComponentGeneratorsUtil.getSuperComponentType(component).ifPresent(superComponent -> this.addFieldsForComputedMethod((TypeElement)superComponent, alreadyDone));
    }

    private TypeMirror getComputedPropertyTypeFromMethod(ExecutableElement method) {
        TypeMirror propertyType = "void".equals(method.getReturnType().toString()) ? method.getParameters().get(0).asType() : method.getReturnType();
        return propertyType;
    }

    private void processWatchers(MethodSpec.Builder createdMethodBuilder) {
        createdMethodBuilder.addStatement("Proto p = $T.cast(vue().$L().getComponentExportedTypePrototype())", Js.class, "$options");
        this.getMethodsWithAnnotation(this.component, Watch.class).forEach(method -> this.processWatcher(createdMethodBuilder, (ExecutableElement)method));
    }

    private void processWatcher(MethodSpec.Builder createdMethodBuilder, ExecutableElement method) {
        Watch watch = method.getAnnotation(Watch.class);
        String exposedMethodName = this.exposeExistingJavaMethodToJs(method);
        String watcherTriggerMethodName = this.addNewMethodToProto();
        MethodSpec.Builder watcherMethodBuilder = MethodSpec.methodBuilder(watcherTriggerMethodName).addModifiers(Modifier.PUBLIC).addAnnotation(JsMethod.class).returns((Type)((Object)Object.class));
        String[] valueSplit = watch.value().split("\\.");
        String currentExpression = "";
        for (int i = 0; i < valueSplit.length - 1; ++i) {
            currentExpression = currentExpression + valueSplit[i];
            watcherMethodBuilder.addStatement("if ($L == null) return null", currentExpression);
            currentExpression = currentExpression + ".";
        }
        watcherMethodBuilder.addStatement("return $L", watch.value());
        this.componentExposedTypeBuilder.addMethod(watcherMethodBuilder.build());
        createdMethodBuilder.addStatement("vue().$L(p.$L, p.$L, $T.of($L, $L))", "$watch", watcherTriggerMethodName, exposedMethodName, WatchOptions.class, watch.isDeep(), watch.isImmediate());
    }

    private void processPropValidators() {
        this.getMethodsWithAnnotation(this.component, PropValidator.class).forEach(method -> {
            PropValidator propValidator = method.getAnnotation(PropValidator.class);
            if (!TypeName.get(method.getReturnType()).equals(TypeName.BOOLEAN)) {
                this.printError("Method " + method.getSimpleName() + " annotated with PropValidator must return a boolean.");
            }
            String exposedMethodName = this.exposeExistingJavaMethodToJs((ExecutableElement)method);
            String propertyName = propValidator.value();
            this.optionsBuilder.addStatement("options.addJavaPropValidator(p.$L, $S)", exposedMethodName, propertyName);
        });
    }

    private void processPropDefaultValues() {
        this.getMethodsWithAnnotation(this.component, PropDefault.class).forEach(method -> {
            PropDefault propValidator = method.getAnnotation(PropDefault.class);
            String exposedMethodName = this.exposeExistingJavaMethodToJs((ExecutableElement)method);
            String propertyName = propValidator.value();
            this.optionsBuilder.addStatement("options.addJavaPropDefaultValue(p.$L, $S)", exposedMethodName, propertyName);
        });
    }

    private void processHooks(Set<ExecutableElement> hookMethodsFromInterfaces) {
        ElementFilter.methodsIn(this.component.getEnclosedElements()).stream().filter(method -> this.isHookMethod(this.component, (ExecutableElement)method, hookMethodsFromInterfaces)).filter(method -> !"created".equals(method.getSimpleName().toString())).forEach(method -> {
            String exposedMethodName = this.exposeExistingJavaMethodToJs((ExecutableElement)method);
            String methodName = method.getSimpleName().toString();
            this.optionsBuilder.addStatement("options.addHookMethod($S, p.$L)", methodName, exposedMethodName);
        });
    }

    private Set<ExecutableElement> getHookMethodsFromInterfaces() {
        return this.component.getInterfaces().stream().map(DeclaredType.class::cast).map(DeclaredType::asElement).map(TypeElement.class::cast).flatMap(typeElement -> ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream()).filter(method -> GeneratorsUtil.hasAnnotation(method, HookMethod.class)).peek(this::validateHookMethod).collect(Collectors.toSet());
    }

    private void validateHookMethod(ExecutableElement hookMethod) {
        if (!ComponentGeneratorsUtil.isMethodVisibleInJS(hookMethod)) {
            this.printError("Method " + hookMethod.getSimpleName() + " annotated with HookMethod should also have @JsMethod property.");
        }
    }

    private void processRenderFunction() {
        if (!GeneratorsUtil.hasInterface(this.processingEnv, this.component.asType(), HasRender.class)) {
            return;
        }
        this.componentExposedTypeBuilder.addMethod(MethodSpec.methodBuilder("vg$render").addModifiers(Modifier.PUBLIC).addAnnotation(JsMethod.class).returns((Type)((Object)VNode.class)).addParameter((Type)((Object)CreateElementFunction.class), "createElementFunction", new Modifier[0]).addStatement("return super.render(new $T(createElementFunction))", VNodeBuilder.class).build());
        this.addMethodToProto("vg$render");
        this.optionsBuilder.addStatement("options.addHookMethod($S, p.$L)", "render", "vg$render");
    }

    private void processRefs() {
        ElementFilter.fieldsIn(this.component.getEnclosedElements()).stream().filter(field -> GeneratorsUtil.hasAnnotation(field, Ref.class)).forEach(this::processRefField);
    }

    private void processRefField(VariableElement field) {
        String refName = field.getSimpleName().toString();
        this.fieldsWithNameExposed.add(new ExposedField(refName, field.asType()));
        this.optionsBuilder.addStatement("options.addRef($S, $T.getFieldName(this, () -> this.$L = $L))", refName, VueGWTTools.class, refName, GeneratorsUtil.getFieldMarkingValueForType(field.asType()));
    }

    private void createCreatedHook(ComponentInjectedDependenciesBuilder dependenciesBuilder) {
        String hasRunCreatedFlagName = "vg$hrc_" + ComponentGeneratorsUtil.getSuperComponentCount(this.component);
        this.componentExposedTypeBuilder.addField(FieldSpec.builder(Boolean.TYPE, hasRunCreatedFlagName, Modifier.PUBLIC).addAnnotation(JsProperty.class).build());
        MethodSpec.Builder createdMethodBuilder = MethodSpec.methodBuilder("vg$created").addModifiers(Modifier.PUBLIC).addAnnotation(JsMethod.class);
        createdMethodBuilder.addStatement("if ($L) return", hasRunCreatedFlagName).addStatement("$L = true", hasRunCreatedFlagName);
        createdMethodBuilder.addStatement("vue().$L().proxyFields(this)", "$options");
        this.injectDependencies(this.component, dependenciesBuilder, createdMethodBuilder);
        this.initFieldsValues(this.component, createdMethodBuilder);
        this.processWatchers(createdMethodBuilder);
        if (GeneratorsUtil.hasInterface(this.processingEnv, this.component.asType(), HasCreated.class)) {
            createdMethodBuilder.addStatement("super.created()", new Object[0]);
        }
        this.componentExposedTypeBuilder.addMethod(createdMethodBuilder.build());
        this.addMethodToProto("vg$created");
        this.optionsBuilder.addStatement("options.addHookMethod($S, p.$L)", "created", "vg$created");
    }

    private void injectDependencies(TypeElement component, ComponentInjectedDependenciesBuilder dependenciesBuilder, MethodSpec.Builder createdMethodBuilder) {
        if (!dependenciesBuilder.hasInjectedDependencies()) {
            return;
        }
        this.createDependenciesInstance(component, createdMethodBuilder);
        this.copyDependenciesFields(dependenciesBuilder, createdMethodBuilder);
        this.callMethodsWithDependencies(dependenciesBuilder, createdMethodBuilder);
    }

    private void createDependenciesInstance(TypeElement component, MethodSpec.Builder createdMethodBuilder) {
        ClassName dependenciesName = GeneratorsNameUtil.componentInjectedDependenciesName(component);
        createdMethodBuilder.addStatement("$T dependencies = ($T) vue().$L.getProvider($T.class).get()", dependenciesName, dependenciesName, "$options()", component);
    }

    private void copyDependenciesFields(ComponentInjectedDependenciesBuilder dependenciesBuilder, MethodSpec.Builder createdMethodBuilder) {
        dependenciesBuilder.getInjectedFieldsName().forEach(fieldName -> createdMethodBuilder.addStatement("super.$L = dependencies.$L", fieldName, fieldName));
    }

    private void callMethodsWithDependencies(ComponentInjectedDependenciesBuilder dependenciesBuilder, MethodSpec.Builder createdMethodBuilder) {
        for (Map.Entry<String, List<String>> methodNameParametersEntry : dependenciesBuilder.getInjectedParametersByMethod().entrySet()) {
            String methodName = methodNameParametersEntry.getKey();
            List callParameters = methodNameParametersEntry.getValue().stream().map(parameterName -> "dependencies." + parameterName).collect(Collectors.toList());
            createdMethodBuilder.addStatement("$L($L)", methodName, String.join((CharSequence)", ", callParameters));
        }
    }

    private void initFieldsValues(TypeElement component, MethodSpec.Builder createdMethodBuilder) {
        if (component.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        createdMethodBuilder.addStatement("$T.initComponentInstanceFields(this, new $T())", VueGWTTools.class, component);
    }

    private String exposeExistingJavaMethodToJs(ExecutableElement originalMethod) {
        Emit emitAnnotation = originalMethod.getAnnotation(Emit.class);
        if (emitAnnotation != null) {
            String methodName = originalMethod.getSimpleName().toString();
            this.createProxyJsMethod(this.componentExposedTypeBuilder, originalMethod, methodName);
            this.addMethodToProto(methodName);
            return methodName;
        }
        if (!ComponentGeneratorsUtil.isMethodVisibleInJS(originalMethod)) {
            String proxyMethodName = this.addNewMethodToProto();
            this.createProxyJsMethod(this.componentExposedTypeBuilder, originalMethod, proxyMethodName);
            return proxyMethodName;
        }
        String methodName = originalMethod.getSimpleName().toString();
        this.addMethodToProto(methodName);
        return methodName;
    }

    public void addMethodToProto(String methodName) {
        this.protoClassBuilder.addField(FieldSpec.builder(Function.class, methodName, new Modifier[]{Modifier.PUBLIC}).build());
    }

    private String addNewMethodToProto() {
        String methodName = METHOD_IN_PROTO_PREFIX + this.methodsInProtoCount;
        this.addMethodToProto(methodName);
        ++this.methodsInProtoCount;
        return methodName;
    }

    private void createProxyJsMethod(TypeSpec.Builder componentExposedTypeBuilder, ExecutableElement originalMethod, String proxyMethodName) {
        boolean hasReturnValue;
        Emit emitAnnotation = originalMethod.getAnnotation(Emit.class);
        MethodSpec.Builder proxyMethodBuilder = MethodSpec.methodBuilder(proxyMethodName).addModifiers(Modifier.PUBLIC).addAnnotation(JsMethod.class).addAnnotation(GeneratorsUtil.getUnusableByJSAnnotation()).returns(ClassName.get(originalMethod.getReturnType()));
        originalMethod.getParameters().forEach(parameter -> proxyMethodBuilder.addParameter(TypeName.get(parameter.asType()), parameter.getSimpleName().toString(), new Modifier[0]));
        String methodCallParameters = this.getSuperMethodCallParameters(originalMethod);
        boolean bl = hasReturnValue = !"void".equals(originalMethod.getReturnType().toString());
        if (hasReturnValue) {
            proxyMethodBuilder.addStatement("$T result = super.$L($L)", originalMethod.getReturnType(), originalMethod.getSimpleName().toString(), methodCallParameters);
        } else {
            proxyMethodBuilder.addStatement("super.$L($L)", originalMethod.getSimpleName().toString(), methodCallParameters);
        }
        if (emitAnnotation != null) {
            this.addEmitEventCall(originalMethod, proxyMethodBuilder, methodCallParameters);
        }
        if (hasReturnValue) {
            proxyMethodBuilder.addStatement("return result", new Object[0]);
        }
        componentExposedTypeBuilder.addMethod(proxyMethodBuilder.build());
    }

    private String getSuperMethodCallParameters(ExecutableElement sourceMethod) {
        return sourceMethod.getParameters().stream().map(parameter -> parameter.getSimpleName().toString()).collect(Collectors.joining(", "));
    }

    private void addEmitEventCall(ExecutableElement originalMethod, MethodSpec.Builder proxyMethodBuilder, String methodCallParameters) {
        String methodName = "$emit";
        if (methodCallParameters != null && !"".equals(methodCallParameters)) {
            proxyMethodBuilder.addStatement("vue().$L($S, $T.asAny($L))", methodName, GeneratorsNameUtil.methodToEventName(originalMethod), Js.class, methodCallParameters);
        } else {
            proxyMethodBuilder.addStatement("vue().$L($S)", methodName, GeneratorsNameUtil.methodToEventName(originalMethod));
        }
    }

    private boolean isHookMethod(TypeElement component, ExecutableElement method, Set<ExecutableElement> hookMethodsFromInterfaces) {
        if (GeneratorsUtil.hasAnnotation(method, HookMethod.class)) {
            this.validateHookMethod(method);
            return true;
        }
        for (ExecutableElement hookMethodsFromInterface : hookMethodsFromInterfaces) {
            if (!this.elements.overrides(method, hookMethodsFromInterface, component)) continue;
            return true;
        }
        return false;
    }

    private Stream<ExecutableElement> getMethodsWithAnnotation(TypeElement component, Class<? extends Annotation> annotation) {
        return ElementFilter.methodsIn(component.getEnclosedElements()).stream().filter(method -> GeneratorsUtil.hasAnnotation(method, annotation));
    }

    private String getNativeNameForJavaType(TypeName typeName) {
        if (this.isNumber(typeName)) {
            return "Number";
        }
        if (this.isBoolean(typeName)) {
            return "Boolean";
        }
        if (this.isString(typeName)) {
            return "String";
        }
        if (this.isArray(typeName)) {
            return "Array";
        }
        return "Object";
    }

    private boolean isNumber(TypeName typeName) {
        return typeName.equals(TypeName.INT) || typeName.equals(TypeName.BYTE) || typeName.equals(TypeName.SHORT) || typeName.equals(TypeName.LONG) || typeName.equals(TypeName.FLOAT) || typeName.equals(TypeName.DOUBLE);
    }

    private boolean isString(TypeName typeName) {
        return typeName.equals(TypeName.get(String.class)) || typeName.equals(TypeName.CHAR);
    }

    private boolean isArray(TypeName typeName) {
        return typeName.toString().startsWith(JsArray.class.getCanonicalName());
    }

    private boolean isBoolean(TypeName typeName) {
        return typeName.equals(TypeName.BOOLEAN) || this.isBooleanObject(typeName);
    }

    private boolean isBooleanObject(TypeName typeName) {
        return typeName.isBoxedPrimitive() && typeName.unbox().equals(TypeName.BOOLEAN);
    }

    private void printError(String message) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message + " In VueComponent: " + this.component.getQualifiedName(), this.component);
    }

    public TypeSpec.Builder getClassBuilder() {
        return this.componentExposedTypeBuilder;
    }

    public MethodSpec.Builder getOptionsBuilder() {
        return this.optionsBuilder;
    }
}

