/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component;

import com.axellience.vuegwt.processors.utils.ComponentGeneratorsUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import com.axellience.vuegwt.processors.utils.InjectedDependenciesUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import vuegwt.shaded.com.squareup.javapoet.AnnotationSpec;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.FieldSpec;
import vuegwt.shaded.com.squareup.javapoet.MethodSpec;
import vuegwt.shaded.com.squareup.javapoet.TypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeSpec;

public class ComponentInjectedDependenciesBuilder {
    private final Messager messager;
    private final TypeSpec.Builder builder;
    private final List<String> injectedFieldsName = new LinkedList<String>();
    private final Map<String, List<String>> injectedParametersByMethod = new HashMap<String, List<String>>();

    public ComponentInjectedDependenciesBuilder(ProcessingEnvironment processingEnvironment, TypeElement component) {
        this.messager = processingEnvironment.getMessager();
        ClassName componentInjectedDependenciesName = GeneratorsNameUtil.componentInjectedDependenciesName(component);
        this.builder = TypeSpec.classBuilder(componentInjectedDependenciesName).addModifiers(Modifier.PUBLIC).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", ComponentInjectedDependenciesBuilder.class.getCanonicalName()).addMember("date", "$S", new Date().toString()).addMember("comments", "$S", "https://github.com/Axellience/vue-gwt").build());
        this.processInjectedFields(component);
        this.processInjectedMethods(component);
        if (this.hasInjectedDependencies()) {
            this.builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addAnnotation(Inject.class).build());
            GeneratorsUtil.toJavaFile(processingEnvironment.getFiler(), this.builder, GeneratorsNameUtil.componentInjectedDependenciesName(component), component);
        }
    }

    private void processInjectedFields(TypeElement component) {
        InjectedDependenciesUtil.getInjectedFields(component).stream().peek(this::validateField).forEach(field -> {
            String fieldName = field.getSimpleName().toString();
            this.addInjectedVariable((VariableElement)field, fieldName);
            this.injectedFieldsName.add(fieldName);
        });
    }

    private void processInjectedMethods(TypeElement component) {
        InjectedDependenciesUtil.getInjectedMethods(component).stream().peek(this::validateMethod).forEach(this::processInjectedMethod);
    }

    private void validateField(VariableElement injectedField) {
        if (injectedField.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Property " + injectedField.getSimpleName() + " in " + injectedField.getEnclosingElement().getSimpleName() + " cannot be injected and private. Please make it at least package protected.");
        }
        if (injectedField.getModifiers().contains((Object)Modifier.FINAL)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Property " + injectedField.getSimpleName() + " in " + injectedField.getEnclosingElement().getSimpleName() + " cannot be injected and final.");
        }
    }

    private void processInjectedMethod(ExecutableElement injectedMethod) {
        String methodName = injectedMethod.getSimpleName().toString();
        LinkedList<String> injectedParameters = new LinkedList<String>();
        this.injectedParametersByMethod.put(methodName, injectedParameters);
        this.processInjectedMethod(injectedMethod, injectedParameters);
    }

    private void processInjectedMethod(ExecutableElement injectedMethod, List<String> injectedParameters) {
        String methodName = injectedMethod.getKind() == ElementKind.CONSTRUCTOR ? "constructor$" : injectedMethod.getSimpleName().toString();
        injectedMethod.getParameters().forEach(injectedParameter -> {
            String parameterName = methodName + "_" + injectedParameter.getSimpleName().toString();
            this.addInjectedVariable((VariableElement)injectedParameter, parameterName);
            injectedParameters.add(parameterName);
        });
    }

    private void validateMethod(ExecutableElement injectedMethod) {
        if (injectedMethod.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method " + injectedMethod.getSimpleName() + " in " + injectedMethod.getEnclosingElement().getSimpleName() + " cannot be injected and private. Please make it at least package protected.");
        }
    }

    private void addInjectedVariable(VariableElement element, String fieldName) {
        TypeName typeName = ComponentGeneratorsUtil.resolveVariableTypeName(element, this.messager);
        FieldSpec.Builder fieldBuilder = FieldSpec.builder(typeName, fieldName, Modifier.PUBLIC);
        element.getAnnotationMirrors().stream().map(AnnotationSpec::get).forEach(fieldBuilder::addAnnotation);
        if (!InjectedDependenciesUtil.hasInjectAnnotation(element)) {
            fieldBuilder.addAnnotation(Inject.class);
        }
        this.builder.addField(fieldBuilder.build());
    }

    public boolean hasInjectedDependencies() {
        return !this.injectedFieldsName.isEmpty() || !this.injectedParametersByMethod.isEmpty();
    }

    List<String> getInjectedFieldsName() {
        return this.injectedFieldsName;
    }

    Map<String, List<String>> getInjectedParametersByMethod() {
        return this.injectedParametersByMethod;
    }
}

