/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.factory;

import com.axellience.vuegwt.core.client.vue.VueComponentFactory;
import com.axellience.vuegwt.processors.utils.ComponentGeneratorsUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import com.axellience.vuegwt.processors.utils.MissingComponentAnnotationException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import vuegwt.shaded.com.squareup.javapoet.AnnotationSpec;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.CodeBlock;
import vuegwt.shaded.com.squareup.javapoet.FieldSpec;
import vuegwt.shaded.com.squareup.javapoet.MethodSpec;
import vuegwt.shaded.com.squareup.javapoet.ParameterizedTypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeSpec;

public abstract class AbstractVueComponentFactoryGenerator {
    private static final String INSTANCE_PROP = "INSTANCE";
    private final ProcessingEnvironment processingEnv;
    private final Filer filer;
    final Messager messager;

    AbstractVueComponentFactoryGenerator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    public void generate(TypeElement component) {
        ClassName vueFactoryClassName = GeneratorsNameUtil.componentFactoryName(component);
        TypeSpec.Builder vueFactoryBuilder = this.createFactoryBuilderClass(component, vueFactoryClassName);
        this.createGetName(vueFactoryBuilder, component);
        this.createProperties(vueFactoryClassName, vueFactoryBuilder);
        List<CodeBlock> staticInitParameters = this.createInitMethod(component, vueFactoryBuilder);
        this.createStaticGetMethod(component, vueFactoryClassName, vueFactoryBuilder, staticInitParameters);
        vueFactoryBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PROTECTED).addAnnotation(Inject.class).build());
        GeneratorsUtil.toJavaFile(this.filer, vueFactoryBuilder, vueFactoryClassName, component);
    }

    private void createGetName(TypeSpec.Builder vueFactoryBuilder, TypeElement component) {
        try {
            String tagName = GeneratorsNameUtil.componentToTagName(component);
            vueFactoryBuilder.addMethod(MethodSpec.methodBuilder("getComponentTagName").returns((Type)((Object)String.class)).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addStatement("return $S", tagName).build());
        }
        catch (MissingComponentAnnotationException e) {
            e.printStackTrace();
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Missing @Component or @JsComponent annotation on component: " + component.toString(), component);
        }
    }

    private TypeSpec.Builder createFactoryBuilderClass(TypeElement component, ClassName vueFactoryClassName) {
        return TypeSpec.classBuilder(vueFactoryClassName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).superclass(ParameterizedTypeName.get(ClassName.get(VueComponentFactory.class), ClassName.get(component))).addAnnotation(Singleton.class).addJavadoc("VueComponentFactory for Component {@link $L}", component.getQualifiedName().toString()).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", this.getClass().getCanonicalName()).addMember("date", "$S", new Date().toString()).addMember("comments", "$S", "https://github.com/Axellience/vue-gwt").build());
    }

    protected abstract List<CodeBlock> createInitMethod(TypeElement var1, TypeSpec.Builder var2);

    private void createProperties(ClassName vueFactoryType, TypeSpec.Builder vueFactoryBuilder) {
        vueFactoryBuilder.addField(FieldSpec.builder(vueFactoryType, INSTANCE_PROP, Modifier.PRIVATE, Modifier.STATIC).build());
    }

    private void createStaticGetMethod(TypeElement component, ClassName vueFactoryClassName, TypeSpec.Builder vueFactoryBuilder, List<CodeBlock> staticInitParameters) {
        MethodSpec.Builder getBuilder = MethodSpec.methodBuilder("get").addModifiers(Modifier.STATIC, Modifier.PUBLIC).returns(vueFactoryClassName);
        getBuilder.beginControlFlow("if ($L == null)", INSTANCE_PROP);
        getBuilder.addStatement("$L = new $T()", INSTANCE_PROP, vueFactoryClassName);
        if (ComponentGeneratorsUtil.hasTemplate(this.processingEnv, component)) {
            getBuilder.addStatement("$L.injectComponentCss($T.getScopedCss())", INSTANCE_PROP, GeneratorsNameUtil.componentExposedTypeName(component));
        }
        getBuilder.addCode("$L.init(", INSTANCE_PROP);
        boolean isFirst = true;
        for (CodeBlock staticInitParameter : staticInitParameters) {
            if (!isFirst) {
                getBuilder.addCode(", ", new Object[0]);
            }
            getBuilder.addCode(staticInitParameter);
            isFirst = false;
        }
        getBuilder.addCode(");", new Object[0]);
        getBuilder.endControlFlow();
        getBuilder.addStatement("return $L", INSTANCE_PROP);
        vueFactoryBuilder.addMethod(getBuilder.build());
    }
}

