/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.factory;

import com.axellience.vuegwt.core.annotations.component.Component;
import com.axellience.vuegwt.core.client.Vue;
import com.axellience.vuegwt.core.client.component.options.VueComponentOptions;
import com.axellience.vuegwt.core.client.directive.options.VueDirectiveOptions;
import com.axellience.vuegwt.core.client.vue.VueJsAsyncProvider;
import com.axellience.vuegwt.core.client.vue.VueJsConstructor;
import com.axellience.vuegwt.processors.component.factory.AbstractVueComponentFactoryGenerator;
import com.axellience.vuegwt.processors.utils.ComponentGeneratorsUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import jsinterop.base.JsPropertyMap;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.CodeBlock;
import vuegwt.shaded.com.squareup.javapoet.MethodSpec;
import vuegwt.shaded.com.squareup.javapoet.ParameterizedTypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeSpec;

public class VueComponentFactoryGenerator
extends AbstractVueComponentFactoryGenerator {
    private final Elements elements;
    private boolean hasInjectedDependencies;

    public VueComponentFactoryGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        this.elements = processingEnv.getElementUtils();
    }

    public void generate(TypeElement component, boolean hasInjectedDependencies) {
        this.hasInjectedDependencies = hasInjectedDependencies;
        super.generate(component);
    }

    @Override
    protected List<CodeBlock> createInitMethod(TypeElement component, TypeSpec.Builder vueFactoryClassBuilder) {
        MethodSpec.Builder initBuilder = MethodSpec.methodBuilder("init").addModifiers(Modifier.PROTECTED).addAnnotation(Inject.class);
        LinkedList<CodeBlock> initParametersCall = new LinkedList<CodeBlock>();
        initBuilder.addStatement("$T<$T> componentOptions = new $T().getOptions()", VueComponentOptions.class, component.asType(), GeneratorsNameUtil.componentExposedTypeName(component));
        this.processCustomizeOptions(component, initBuilder, initParametersCall);
        Optional<ClassName> superFactoryType = ComponentGeneratorsUtil.getSuperComponentType(component).map(GeneratorsNameUtil::componentFactoryName);
        if (superFactoryType.isPresent()) {
            initBuilder.addParameter(superFactoryType.get(), "superFactory", new Modifier[0]);
            initBuilder.addStatement("jsConstructor = superFactory.getJsConstructor().extendJavaComponent($L)", "componentOptions");
            initParametersCall.add(CodeBlock.of("$T.get()", superFactoryType.get()));
        } else {
            initBuilder.addStatement("jsConstructor = $T.extendJavaComponent($L)", Vue.class, "componentOptions");
        }
        Component componentAnnotation = component.getAnnotation(Component.class);
        if (this.hasInjectedDependencies) {
            this.registerDependenciesProvider(component, initBuilder, initParametersCall);
        }
        this.registerLocalComponents(component, initBuilder, initParametersCall);
        this.registerLocalDirectives(componentAnnotation, initBuilder);
        MethodSpec initMethod = initBuilder.build();
        vueFactoryClassBuilder.addMethod(initMethod);
        return initParametersCall;
    }

    private void registerDependenciesProvider(TypeElement component, MethodSpec.Builder initBuilder, List<CodeBlock> staticInitParameters) {
        ClassName componentDependencies = GeneratorsNameUtil.componentInjectedDependenciesName(component);
        initBuilder.addParameter(GeneratorsNameUtil.providerOf(componentDependencies), "componentDependenciesProvider", new Modifier[0]);
        staticInitParameters.add(CodeBlock.of("() -> new $T()", componentDependencies));
        initBuilder.addStatement("jsConstructor.getOptions().addProvider($T.class, componentDependenciesProvider)", component);
    }

    private void registerLocalComponents(TypeElement component, MethodSpec.Builder initBuilder, List<CodeBlock> staticInitParameters) {
        List<TypeMirror> localComponents = ComponentGeneratorsUtil.getComponentLocalComponents(this.elements, component);
        if (localComponents.isEmpty()) {
            return;
        }
        initBuilder.addStatement("$T<$T> components = jsConstructor.getOptionsComponents()", JsPropertyMap.class, ParameterizedTypeName.get(VueJsAsyncProvider.class, new Type[]{VueJsConstructor.class}));
        localComponents.forEach(localComponent -> {
            ClassName factory = GeneratorsNameUtil.componentFactoryName(localComponent);
            String parameterName = factory.reflectionName().replaceAll("\\.", "_");
            initBuilder.addParameter(GeneratorsNameUtil.providerOf(factory), parameterName, new Modifier[0]);
            staticInitParameters.add(CodeBlock.of("() -> $T.get()", factory));
            initBuilder.addStatement("components.set($L.get().getComponentTagName(), render -> render.accept($L.get().getJsConstructor()))", parameterName, parameterName);
        });
    }

    private void registerLocalDirectives(Component annotation, MethodSpec.Builder initBuilder) {
        try {
            Class[] componentsClass = annotation.directives();
            if (componentsClass.length > 0) {
                this.addGetDirectivesStatement(initBuilder);
            }
            Stream.of(componentsClass).forEach(clazz -> initBuilder.addStatement("directives.set($S, new $T())", GeneratorsNameUtil.directiveToTagName(clazz.getName()), GeneratorsNameUtil.directiveOptionsName(clazz)));
        }
        catch (MirroredTypesException mte) {
            List<? extends TypeMirror> classTypeMirrors = mte.getTypeMirrors();
            if (!classTypeMirrors.isEmpty()) {
                this.addGetDirectivesStatement(initBuilder);
            }
            classTypeMirrors.forEach(classTypeMirror -> {
                TypeElement classTypeElement = (TypeElement)classTypeMirror.asElement();
                initBuilder.addStatement("directives.set($S, new $T())", GeneratorsNameUtil.directiveToTagName(classTypeElement.getSimpleName().toString()), GeneratorsNameUtil.directiveOptionsName(classTypeElement));
            });
        }
    }

    private void addGetDirectivesStatement(MethodSpec.Builder injectDependenciesBuilder) {
        injectDependenciesBuilder.addStatement("$T<$T> directives = jsConstructor.getOptionsDirectives()", JsPropertyMap.class, VueDirectiveOptions.class);
    }

    private void processCustomizeOptions(TypeElement component, MethodSpec.Builder initBuilder, List<CodeBlock> staticInitParameters) {
        ComponentGeneratorsUtil.getComponentCustomizeOptions(this.elements, component).forEach(customizeOptions -> this.processCustomizeOptions((TypeMirror)customizeOptions, initBuilder, staticInitParameters));
    }

    private void processCustomizeOptions(TypeMirror customizeOptions, MethodSpec.Builder initBuilder, List<CodeBlock> staticInitParameters) {
        ClassName customizeOptionsClassName = (ClassName)ClassName.get(customizeOptions);
        char[] c = customizeOptionsClassName.simpleName().toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        String parameterName = new String(c);
        initBuilder.addParameter(customizeOptionsClassName, parameterName, new Modifier[0]);
        staticInitParameters.add(CodeBlock.of("new $T()", customizeOptionsClassName));
        initBuilder.addStatement("$L.$L($L)", parameterName, "customizeOptions", "componentOptions");
    }

    private void printError(String message, TypeElement component) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message + " In VueComponent: " + component.getQualifiedName());
    }
}

