/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template;

import com.axellience.vuegwt.core.annotations.component.Component;
import com.axellience.vuegwt.core.annotations.component.Computed;
import com.axellience.vuegwt.core.annotations.component.Data;
import com.axellience.vuegwt.core.annotations.component.Prop;
import com.axellience.vuegwt.core.annotations.component.Ref;
import com.axellience.vuegwt.processors.component.ComponentExposedTypeGenerator;
import com.axellience.vuegwt.processors.component.template.builder.TemplateMethodsBuilder;
import com.axellience.vuegwt.processors.component.template.parser.TemplateParser;
import com.axellience.vuegwt.processors.component.template.parser.context.TemplateParserContext;
import com.axellience.vuegwt.processors.component.template.parser.context.localcomponents.LocalComponent;
import com.axellience.vuegwt.processors.component.template.parser.context.localcomponents.LocalComponents;
import com.axellience.vuegwt.processors.component.template.parser.refs.RefFieldValidator;
import com.axellience.vuegwt.processors.component.template.parser.refs.RefInfo;
import com.axellience.vuegwt.processors.component.template.parser.result.TemplateParserResult;
import com.axellience.vuegwt.processors.utils.ComponentGeneratorsUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import com.axellience.vuegwt.processors.utils.MissingComponentAnnotationException;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.MethodSpec;
import vuegwt.shaded.com.squareup.javapoet.ParameterizedTypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeSpec;

public class ComponentTemplateProcessor {
    private final ProcessingEnvironment processingEnvironment;
    private final Filer filer;
    private final Messager messager;
    private final Elements elements;

    public ComponentTemplateProcessor(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.filer = processingEnvironment.getFiler();
        this.messager = processingEnvironment.getMessager();
        this.elements = processingEnvironment.getElementUtils();
    }

    public void processComponentTemplate(TypeElement componentTypeElement, ComponentExposedTypeGenerator exposedTypeGenerator) {
        ClassName componentTypeName = ClassName.get(componentTypeElement);
        Optional<TemplateFileResource> optionalTemplateContent = this.getTemplateContent(componentTypeName, componentTypeElement);
        if (!optionalTemplateContent.isPresent()) {
            return;
        }
        LocalComponents localComponents = new LocalComponents();
        this.findLocalComponentsForComponent(localComponents, componentTypeElement);
        TemplateParserContext templateParserContext = new TemplateParserContext(componentTypeElement, localComponents);
        this.registerFieldsAndMethodsInContext(templateParserContext, componentTypeElement, new HashSet<String>(), new HashSet<String>());
        TemplateParserResult templateParserResult = new TemplateParser().parseHtmlTemplate(optionalTemplateContent.get().content, templateParserContext, this.elements, this.messager, optionalTemplateContent.get().uri);
        this.validateRefs(templateParserResult.getRefs(), componentTypeElement);
        ComponentTemplateProcessor.registerScopedCss(exposedTypeGenerator.getClassBuilder(), templateParserResult);
        TemplateMethodsBuilder templateMethodsBuilder = new TemplateMethodsBuilder();
        templateMethodsBuilder.addTemplateMethodsToComponentExposedType(exposedTypeGenerator, templateParserResult);
    }

    private void registerFieldsAndMethodsInContext(TemplateParserContext templateParserContext, TypeElement componentTypeElement, Set<String> alreadyDoneVariable, Set<String> alreadyDoneMethods) {
        ElementFilter.fieldsIn(componentTypeElement.getEnclosedElements()).stream().filter(field -> field.getAnnotation(Data.class) != null || field.getAnnotation(Prop.class) != null).forEach(field -> {
            String name = field.getSimpleName().toString();
            if (alreadyDoneVariable.contains(name)) {
                return;
            }
            alreadyDoneVariable.add(name);
            templateParserContext.addRootVariable(ClassName.get(field.asType()), name);
        });
        ElementFilter.methodsIn(componentTypeElement.getEnclosedElements()).stream().filter(method -> GeneratorsUtil.hasAnnotation(method, Computed.class)).filter(method -> !"void".equals(method.getReturnType().toString())).forEach(method -> {
            String name = GeneratorsUtil.getComputedPropertyName(method);
            if (alreadyDoneVariable.contains(name)) {
                return;
            }
            alreadyDoneVariable.add(name);
            TypeMirror propertyType = "void".equals(method.getReturnType().toString()) ? method.getParameters().get(0).asType() : method.getReturnType();
            templateParserContext.addRootComputedProperty(ClassName.get(propertyType), name, GeneratorsNameUtil.computedPropertyNameToFieldName(name));
        });
        ElementFilter.methodsIn(componentTypeElement.getEnclosedElements()).stream().filter(ComponentGeneratorsUtil::isMethodVisibleInTemplate).map(ExecutableElement::getSimpleName).map(Object::toString).forEach(methodName -> {
            if (alreadyDoneMethods.contains(methodName)) {
                return;
            }
            alreadyDoneMethods.add((String)methodName);
            templateParserContext.addRootMethod((String)methodName);
        });
        ComponentGeneratorsUtil.getSuperComponentType(componentTypeElement).ifPresent(superComponent -> this.registerFieldsAndMethodsInContext(templateParserContext, (TypeElement)superComponent, alreadyDoneVariable, alreadyDoneMethods));
    }

    private void findLocalComponentsForComponent(LocalComponents localComponents, TypeElement componentTypeElement) {
        Component componentAnnotation = componentTypeElement.getAnnotation(Component.class);
        if (componentAnnotation == null) {
            return;
        }
        this.processLocalComponentClass(localComponents, componentTypeElement);
        ComponentGeneratorsUtil.getComponentLocalComponents(this.elements, componentTypeElement).stream().map(DeclaredType.class::cast).map(DeclaredType::asElement).map(TypeElement.class::cast).forEach(childTypeElement -> this.processLocalComponentClass(localComponents, (TypeElement)childTypeElement));
        ComponentGeneratorsUtil.getSuperComponentType(componentTypeElement).ifPresent(superComponentType -> this.findLocalComponentsForComponent(localComponents, (TypeElement)superComponentType));
    }

    private void processLocalComponentClass(LocalComponents localComponents, TypeElement localComponentType) {
        String localComponentTagName;
        try {
            localComponentTagName = GeneratorsNameUtil.componentToTagName(localComponentType);
        }
        catch (MissingComponentAnnotationException e) {
            e.printStackTrace();
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Missing @Component or @JsComponent annotation on imported component: " + localComponentType.toString(), localComponentType);
            return;
        }
        if (localComponents.hasLocalComponent(localComponentTagName)) {
            return;
        }
        LocalComponent localComponent = localComponents.addLocalComponent(localComponentTagName, localComponentType.asType());
        ElementFilter.fieldsIn(localComponentType.getEnclosedElements()).forEach(field -> {
            Prop propAnnotation = field.getAnnotation(Prop.class);
            if (propAnnotation != null) {
                localComponent.addProp(field.getSimpleName().toString(), TypeName.get(field.asType()), propAnnotation.required());
            }
        });
    }

    private void validateRefs(Set<RefInfo> templateRefs, TypeElement component) {
        RefFieldValidator refFieldValidator = new RefFieldValidator(component, templateRefs, this.processingEnvironment);
        ElementFilter.fieldsIn(component.getEnclosedElements()).stream().filter(field -> GeneratorsUtil.hasAnnotation(field, Ref.class)).forEach(refFieldValidator::validateRefField);
    }

    private Optional<TemplateFileResource> getTemplateContent(ClassName componentTypeName, TypeElement componentTypeElement) {
        String path = ComponentTemplateProcessor.slashify(componentTypeName.reflectionName()) + ".html";
        Optional<TemplateFileResource> result = this.getTemplateContentAtLocation(path, StandardLocation.CLASS_OUTPUT);
        if (result.isPresent()) {
            return result;
        }
        result = this.getTemplateContentAtLocation(path, StandardLocation.CLASS_PATH);
        if (result.isPresent()) {
            return result;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "Couldn't find template for component: " + componentTypeName.simpleName() + ". Make sure you included src/main/java in your Resources. Check our setup guide for help.", componentTypeElement);
        return Optional.empty();
    }

    private Optional<TemplateFileResource> getTemplateContentAtLocation(String path, StandardLocation location) {
        FileObject resource;
        try {
            resource = this.filer.getResource(location, "", path);
        }
        catch (IOException ignore) {
            return Optional.empty();
        }
        try {
            return Optional.of(new TemplateFileResource(resource.getCharContent(true).toString(), resource.toUri()));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private static void registerScopedCss(TypeSpec.Builder componentExposedTypeBuilder, TemplateParserResult templateParserResult) {
        String scopedCss = templateParserResult.getScopedCss();
        componentExposedTypeBuilder.addMethod(MethodSpec.methodBuilder("getScopedCss").addModifiers(Modifier.STATIC, Modifier.PUBLIC).returns(ParameterizedTypeName.get(String.class)).addStatement("return $S", scopedCss).build());
    }

    private static String slashify(String s2) {
        return s2.replace(".", "/").replace("$", ".");
    }

    private static class TemplateFileResource {
        public final String content;
        public final URI uri;

        public TemplateFileResource(String content, URI uri) {
            this.content = content;
            this.uri = uri;
        }
    }
}

