/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.builder;

import com.axellience.vuegwt.core.client.tools.VueGWTTools;
import com.axellience.vuegwt.processors.component.ComponentExposedTypeGenerator;
import com.axellience.vuegwt.processors.component.template.builder.compiler.VueTemplateCompiler;
import com.axellience.vuegwt.processors.component.template.builder.compiler.VueTemplateCompilerException;
import com.axellience.vuegwt.processors.component.template.builder.compiler.VueTemplateCompilerResult;
import com.axellience.vuegwt.processors.component.template.parser.result.TemplateExpression;
import com.axellience.vuegwt.processors.component.template.parser.result.TemplateParserResult;
import com.axellience.vuegwt.processors.component.template.parser.variable.ComputedVariableInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.VariableInfo;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import elemental2.core.Function;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import jsinterop.annotations.JsMethod;
import jsinterop.base.Js;
import vuegwt.shaded.com.squareup.javapoet.CodeBlock;
import vuegwt.shaded.com.squareup.javapoet.MethodSpec;

public class TemplateMethodsBuilder {
    public void addTemplateMethodsToComponentExposedType(ComponentExposedTypeGenerator exposedTypeGenerator, TemplateParserResult templateParserResult) {
        this.compileTemplateString(exposedTypeGenerator, templateParserResult);
        this.processTemplateExpressions(exposedTypeGenerator, templateParserResult);
    }

    private void compileTemplateString(ComponentExposedTypeGenerator exposedTypeGenerator, TemplateParserResult templateParserResult) {
        VueTemplateCompilerResult compilerResult;
        try {
            VueTemplateCompiler vueTemplateCompiler = new VueTemplateCompiler();
            compilerResult = vueTemplateCompiler.compile(templateParserResult.getProcessedTemplate());
        }
        catch (VueTemplateCompilerException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        this.generateGetRenderFunction(exposedTypeGenerator, compilerResult, templateParserResult);
        this.generateGetStaticRenderFunctions(exposedTypeGenerator, compilerResult);
    }

    private void generateGetRenderFunction(ComponentExposedTypeGenerator exposedTypeGenerator, VueTemplateCompilerResult result, TemplateParserResult templateParserResult) {
        MethodSpec.Builder getRenderFunctionBuilder = MethodSpec.methodBuilder("getRenderFunction").addModifiers(Modifier.PRIVATE).returns((Type)((Object)Function.class)).addStatement("String renderFunctionString = $S", result.getRenderFunction());
        for (VariableInfo markedDataField : templateParserResult.getMarkedDataFields()) {
            String placeHolderDataFieldValue = GeneratorsNameUtil.markedDataFieldToPlaceHolderField(markedDataField.getName());
            String fieldName = markedDataField.getName();
            if (markedDataField instanceof ComputedVariableInfo) {
                fieldName = ((ComputedVariableInfo)markedDataField).getFieldName();
            }
            getRenderFunctionBuilder.addStatement("renderFunctionString = $T.replaceVariableInRenderFunction(renderFunctionString, $S, this, () -> this.$L = $L)", VueGWTTools.class, placeHolderDataFieldValue, fieldName, GeneratorsUtil.getFieldMarkingValueForType(markedDataField.getType()));
        }
        getRenderFunctionBuilder.addStatement("return new $T(renderFunctionString)", Function.class);
        exposedTypeGenerator.getClassBuilder().addMethod(getRenderFunctionBuilder.build());
    }

    private void generateGetStaticRenderFunctions(ComponentExposedTypeGenerator exposedTypeGenerator, VueTemplateCompilerResult result) {
        CodeBlock.Builder staticFunctions = CodeBlock.builder();
        boolean isFirst = true;
        for (String staticRenderFunction : result.getStaticRenderFunctions()) {
            if (!isFirst) {
                staticFunctions.add(", ", new Object[0]);
            } else {
                isFirst = false;
            }
            staticFunctions.add("new $T($S)", Function.class, staticRenderFunction);
        }
        MethodSpec.Builder getStaticRenderFunctionsBuilder = MethodSpec.methodBuilder("getStaticRenderFunctions").addModifiers(Modifier.PRIVATE).returns((Type)((Object)Function[].class)).addStatement("return new $T[] { $L }", Function.class, staticFunctions.build());
        exposedTypeGenerator.getClassBuilder().addMethod(getStaticRenderFunctionsBuilder.build());
    }

    private void processTemplateExpressions(ComponentExposedTypeGenerator exposedTypeGenerator, TemplateParserResult templateParserResult) {
        for (TemplateExpression expression2 : templateParserResult.getExpressions()) {
            this.generateTemplateExpressionMethod(exposedTypeGenerator, expression2, templateParserResult.getTemplateName());
        }
        String templateMethods = templateParserResult.getExpressions().stream().map(expression -> "p." + expression.getId()).collect(Collectors.joining(", "));
        exposedTypeGenerator.getOptionsBuilder().addStatement("options.registerTemplateMethods($L)", templateMethods);
    }

    private void generateTemplateExpressionMethod(ComponentExposedTypeGenerator exposedTypeGenerator, TemplateExpression expression, String templateName) {
        MethodSpec.Builder templateExpressionMethodBuilder = MethodSpec.methodBuilder(expression.getId()).addModifiers(Modifier.PUBLIC).addAnnotation(JsMethod.class).addAnnotation(GeneratorsUtil.getUnusableByJSAnnotation()).returns(expression.getType());
        String expressionPosition = templateName;
        if (expression.getLineInHtml() != null) {
            expressionPosition = expressionPosition + ", line " + expression.getLineInHtml();
        }
        templateExpressionMethodBuilder.addComment(expressionPosition, new Object[0]);
        expression.getParameters().forEach(parameter -> templateExpressionMethodBuilder.addParameter(parameter.getType(), parameter.getName(), new Modifier[0]));
        if (expression.isReturnString()) {
            templateExpressionMethodBuilder.addStatement("return $T.templateExpressionToString($L)", VueGWTTools.class, expression.getBody());
        } else if (expression.isReturnVoid()) {
            templateExpressionMethodBuilder.addStatement("$L", expression.getBody());
        } else if (expression.isReturnAny()) {
            templateExpressionMethodBuilder.addStatement("return $T.asAny($L)", Js.class, expression.getBody());
        } else if (expression.isShouldCast()) {
            templateExpressionMethodBuilder.addStatement("return ($T) ($L)", expression.getType(), expression.getBody());
        } else {
            templateExpressionMethodBuilder.addStatement("return $L", expression.getBody());
        }
        exposedTypeGenerator.getClassBuilder().addMethod(templateExpressionMethodBuilder.build());
        exposedTypeGenerator.addMethodToProto(expression.getId());
    }
}

