/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.builder.compiler;

import com.axellience.vuegwt.processors.component.template.builder.compiler.JsVueTemplateCompiler;
import com.axellience.vuegwt.processors.component.template.builder.compiler.VueTemplateCompilerException;
import com.axellience.vuegwt.processors.component.template.builder.compiler.VueTemplateCompilerResult;
import java.util.List;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class VueTemplateCompiler {
    private static Context context;
    private static Scriptable scope;

    public VueTemplateCompiler() {
        if (context == null) {
            this.initEngine();
        }
    }

    private void initEngine() {
        context = Context.enter();
        scope = context.initStandardObjects();
        context.evaluateString(scope, "(function(global){global.global = global})(this);", "<cmd>", 1, null);
        context.evaluateString(scope, JsVueTemplateCompiler.JS_VUE_TEMPLATE_COMPILER, "<cmd>", 1, null);
    }

    public VueTemplateCompilerResult compile(String htmlTemplate) throws VueTemplateCompilerException {
        Object vueCompilerFunction = scope.get("compile", scope);
        if (!(vueCompilerFunction instanceof Function)) {
            throw new VueTemplateCompilerException("An error occurred while compiling the template: " + htmlTemplate);
        }
        Object[] vueCompilerArgs = new Object[]{htmlTemplate};
        Function f = (Function)vueCompilerFunction;
        Object result = f.call(context, scope, scope, vueCompilerArgs);
        NativeObject templateCompilerResult = (NativeObject)Context.jsToJava(result, NativeObject.class);
        String render = ((ConsString)templateCompilerResult.get("render")).toString();
        String[] staticRenderFunctions = (String[])((List)templateCompilerResult.get("staticRenderFns")).stream().map(s2 -> ((ConsString)s2).toString()).toArray(String[]::new);
        return new VueTemplateCompilerResult(render, staticRenderFunctions);
    }
}

