/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser;

import com.axellience.vuegwt.processors.component.template.parser.TemplateParserLogger;
import com.axellience.vuegwt.processors.component.template.parser.context.TemplateParserContext;
import com.axellience.vuegwt.processors.component.template.parser.variable.LocalVariableInfo;
import jsinterop.base.JsPropertyMap;

class SlotScopeDefinition {
    private final String value;
    private final TemplateParserContext context;
    private final TemplateParserLogger logger;
    private String slotScopeVariableName;

    public SlotScopeDefinition(String value, TemplateParserContext context, TemplateParserLogger logger) {
        this.value = value.trim();
        this.context = context;
        this.logger = logger;
        if (this.value.startsWith("{")) {
            this.processParameterDestructuring();
        } else {
            this.processSimpleSlotScope();
        }
    }

    private void processSimpleSlotScope() {
        this.slotScopeVariableName = this.value;
        this.context.addLocalVariable(JsPropertyMap.class.getCanonicalName(), this.value);
    }

    private void processParameterDestructuring() {
        String[] variables;
        LocalVariableInfo destructuredVariable = this.context.addUniqueLocalVariable(JsPropertyMap.class.getCanonicalName());
        this.slotScopeVariableName = destructuredVariable.getName();
        for (String property : variables = this.value.substring(1, this.value.length() - 1).split(",")) {
            this.processDestructuredProperty(property, destructuredVariable);
        }
    }

    private void processDestructuredProperty(String property, LocalVariableInfo destructuredVariable) {
        String[] propertySplit = (property = property.trim()).split(" ");
        if (propertySplit.length != 2) {
            this.logger.error("Invalid slot scope definition found. Must be in the form {String myStringValue, int myIntValue}", this.value);
            return;
        }
        String propertyType = this.context.getFullyQualifiedNameForClassName(propertySplit[0].trim());
        String propertyName = propertySplit[1].trim();
        this.context.addDestructuredProperty(propertyType, propertyName, destructuredVariable);
    }

    String getSlotScopeVariableName() {
        return this.slotScopeVariableName;
    }
}

