/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser;

import com.axellience.vuegwt.processors.component.template.parser.SlotScopeDefinition;
import com.axellience.vuegwt.processors.component.template.parser.TemplateParserLogger;
import com.axellience.vuegwt.processors.component.template.parser.TemplateScopedCssParser;
import com.axellience.vuegwt.processors.component.template.parser.VForDefinition;
import com.axellience.vuegwt.processors.component.template.parser.context.TemplateParserContext;
import com.axellience.vuegwt.processors.component.template.parser.context.localcomponents.LocalComponent;
import com.axellience.vuegwt.processors.component.template.parser.context.localcomponents.LocalComponentProp;
import com.axellience.vuegwt.processors.component.template.parser.jericho.TemplateParserLoggerProvider;
import com.axellience.vuegwt.processors.component.template.parser.result.TemplateExpression;
import com.axellience.vuegwt.processors.component.template.parser.result.TemplateParserResult;
import com.axellience.vuegwt.processors.component.template.parser.variable.ComputedVariableInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.DestructuredPropertyInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.LocalVariableInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.VariableInfo;
import com.axellience.vuegwt.processors.dom.DOMElementsUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.context.StringContext;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.processing.Messager;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import jsinterop.base.Any;
import vuegwt.shaded.com.github.javaparser.JavaParser;
import vuegwt.shaded.com.github.javaparser.ast.Node;
import vuegwt.shaded.com.github.javaparser.ast.expr.BinaryExpr;
import vuegwt.shaded.com.github.javaparser.ast.expr.CastExpr;
import vuegwt.shaded.com.github.javaparser.ast.expr.Expression;
import vuegwt.shaded.com.github.javaparser.ast.expr.MethodCallExpr;
import vuegwt.shaded.com.github.javaparser.ast.expr.NameExpr;
import vuegwt.shaded.com.github.javaparser.ast.nodeTypes.NodeWithType;
import vuegwt.shaded.com.github.javaparser.ast.type.Type;
import vuegwt.shaded.com.squareup.javapoet.TypeName;
import vuegwt.shaded.net.htmlparser.jericho.Attribute;
import vuegwt.shaded.net.htmlparser.jericho.Attributes;
import vuegwt.shaded.net.htmlparser.jericho.CharacterReference;
import vuegwt.shaded.net.htmlparser.jericho.Config;
import vuegwt.shaded.net.htmlparser.jericho.Element;
import vuegwt.shaded.net.htmlparser.jericho.OutputDocument;
import vuegwt.shaded.net.htmlparser.jericho.Segment;
import vuegwt.shaded.net.htmlparser.jericho.Source;
import vuegwt.shaded.net.htmlparser.jericho.Tag;

public class TemplateParser {
    private static Pattern VUE_ATTR_PATTERN = Pattern.compile("^(v-|:|@).*");
    private static Pattern VUE_MUSTACHE_PATTERN = Pattern.compile("\\{\\{.*?}}", 32);
    private JavaParser javaParser;
    private TemplateParserContext context;
    private Elements elements;
    private Messager messager;
    private TemplateParserLogger logger;
    private TemplateParserResult result;
    private URI htmlTemplateUri;
    private Attribute currentAttribute;
    private LocalComponentProp currentProp;
    private TypeName currentExpressionReturnType;
    private OutputDocument outputDocument;

    public TemplateParserResult parseHtmlTemplate(String htmlTemplate, TemplateParserContext context, Elements elements, Messager messager, URI htmlTemplateUri) {
        this.context = context;
        this.elements = elements;
        this.messager = messager;
        this.logger = new TemplateParserLogger(context, messager);
        this.htmlTemplateUri = htmlTemplateUri;
        this.javaParser = new JavaParser();
        TemplateParser.initJerichoConfig(this.logger);
        Source source = new Source(htmlTemplate);
        this.outputDocument = new OutputDocument(source);
        this.result = new TemplateParserResult(context);
        this.processImports(source);
        this.result.setScopedCss(this.processScopedCss(source));
        source.getChildElements().forEach(this::processElement);
        this.result.setProcessedTemplate(this.outputDocument.toString());
        return this.result;
    }

    private static void initJerichoConfig(TemplateParserLogger logger) {
        Attributes.setDefaultMaxErrorCount(Integer.MAX_VALUE);
        Config.IsHTMLEmptyElementTagRecognised = true;
        Config.LoggerProvider = new TemplateParserLoggerProvider(logger);
    }

    private void processImports(Source doc) {
        doc.getAllElements().stream().filter(element -> "vue-gwt:import".equalsIgnoreCase(element.getName())).peek(importElement -> {
            String staticAttributeValue;
            String classAttributeValue = importElement.getAttributeValue("class");
            if (classAttributeValue != null) {
                this.context.addImport(classAttributeValue);
            }
            if ((staticAttributeValue = importElement.getAttributeValue("static")) != null) {
                this.context.addStaticImport(staticAttributeValue);
            }
        }).forEach(this.outputDocument::remove);
    }

    private static boolean isScopedStyleElement(Element element) {
        return element != null && "style".equalsIgnoreCase(element.getName()) && element.getAttributes() != null && element.getAttributes().get("scoped") != null;
    }

    private String processScopedCss(Source doc) {
        String[] scopedCss = new String[1];
        doc.getAllElements().stream().filter(TemplateParser::isScopedStyleElement).peek(styleScoped -> {
            String css = styleScoped.getContent().toString().trim();
            if (!css.isEmpty()) {
                TemplateScopedCssParser scopedCssParser;
                Optional<TemplateScopedCssParser.ScopedCssResult> scopedCssResult;
                String lang = styleScoped.getAttributeValue("lang");
                if ("scss".equalsIgnoreCase(lang)) {
                    css = this.scssToCss(css);
                }
                if ((scopedCssResult = (scopedCssParser = new TemplateScopedCssParser(this.messager)).parse(this.context.getComponentTypeElement(), css)).isPresent()) {
                    this.context.getMandatoryAttributes().putAll(scopedCssResult.get().mandatoryAttributes);
                    scopedCss[0] = scopedCssResult.get().scopedCss;
                }
            }
        }).forEach(this.outputDocument::remove);
        return scopedCss[0];
    }

    private String scssToCss(String scss) {
        Compiler compiler = new Compiler();
        Options options = new Options();
        try {
            StringContext context = new StringContext(scss, this.htmlTemplateUri, null, options);
            Output output = compiler.compile(context);
            return output.getCss();
        }
        catch (CompilationException e) {
            this.logger.error("SCSS compile failed: " + e.getErrorText());
            throw new RuntimeException(e);
        }
    }

    private void processElement(Element element) {
        this.context.setCurrentSegment(element);
        this.currentProp = null;
        this.currentAttribute = null;
        boolean shouldPopContext = this.processElementAttributes(element);
        StreamSupport.stream(((Iterable)element::getNodeIterator).spliterator(), false).filter(segment -> !(segment instanceof Tag) && !(segment instanceof CharacterReference)).filter(segment -> {
            for (Element child : element.getChildElements()) {
                if (!child.encloses((Segment)segment)) continue;
                return false;
            }
            return true;
        }).forEach(this::processTextNode);
        element.getChildElements().forEach(this::processElement);
        if (shouldPopContext) {
            this.context.popContextLayer();
        }
    }

    private boolean processElementAttributes(Element element) {
        String processedScopedSlotValue;
        Attributes attributes = element.getAttributes();
        if (attributes == null) {
            return false;
        }
        boolean shouldPopContext = false;
        this.registerMandatoryAttributes(attributes);
        Attribute vForAttribute = attributes.get("v-for");
        Attribute slotScopeAttribute = attributes.get("slot-scope");
        Attribute vSlotAttribute = null;
        for (Attribute attribute : attributes) {
            if (!TemplateParser.isVSlot(attribute)) continue;
            vSlotAttribute = attribute;
        }
        if (vForAttribute != null || slotScopeAttribute != null || vSlotAttribute != null && !vSlotAttribute.getValue().isEmpty()) {
            shouldPopContext = true;
            this.context.addContextLayer(vForAttribute != null);
        }
        if (vForAttribute != null) {
            String processedVForValue = this.processVForValue(vForAttribute.getValue());
            this.outputDocument.replace(vForAttribute.getValueSegment(), processedVForValue);
        }
        if (slotScopeAttribute != null) {
            processedScopedSlotValue = this.processSlotScopeValue(slotScopeAttribute.getValue());
            this.outputDocument.replace(slotScopeAttribute.getValueSegment(), processedScopedSlotValue);
        }
        if (vSlotAttribute != null) {
            processedScopedSlotValue = this.processSlotScopeValue(vSlotAttribute.getValue());
            this.outputDocument.replace(vSlotAttribute.getValueSegment(), processedScopedSlotValue);
        }
        Optional<LocalComponent> localComponent = this.getLocalComponentForElement(element);
        Attribute refAttribute = attributes.get("ref");
        if (refAttribute != null) {
            this.result.addRef(refAttribute.getValue(), localComponent.map(LocalComponent::getComponentType).orElse(this.getTypeFromDOMElement(element)), this.context.isInVFor());
        }
        Map elementPropertiesType = this.getPropertiesForDOMElement(element).orElse(new HashMap());
        HashSet foundProps = new HashSet();
        for (Attribute attribute : element.getAttributes()) {
            String key = attribute.getKey();
            if ("v-for".equals(key) || "slot-scope".equals(key) || TemplateParser.isVSlot(attribute)) continue;
            if ("v-model".equals(key)) {
                this.processVModel(attribute);
                continue;
            }
            if (TemplateParser.isAttributeBinding(attribute) && key.toLowerCase().endsWith(".sync")) {
                this.processSyncProp(attribute);
                continue;
            }
            Optional optionalProp = localComponent.flatMap(lc -> lc.getPropForAttribute(attribute.getName()));
            optionalProp.ifPresent(foundProps::add);
            if (!VUE_ATTR_PATTERN.matcher(key).matches()) {
                LocalComponentProp prop;
                if (!optionalProp.isPresent() || this.isBooleanBinding(attribute, prop = (LocalComponentProp)optionalProp.get())) continue;
                this.validateStringPropBinding(prop);
                continue;
            }
            this.context.setCurrentSegment(attribute);
            this.currentAttribute = attribute;
            this.currentProp = optionalProp.orElse(null);
            this.currentExpressionReturnType = this.getExpressionReturnTypeForAttribute(attribute, elementPropertiesType);
            String processedExpression = this.processExpression(attribute.getValue());
            if (!attribute.hasValue()) continue;
            this.outputDocument.replace(attribute.getValueSegment(), processedExpression);
        }
        localComponent.ifPresent(lc -> this.validateRequiredProps((LocalComponent)lc, foundProps));
        return shouldPopContext;
    }

    private TypeMirror getTypeFromDOMElement(Element element) {
        return DOMElementsUtil.getTypeForElementTag(element.getStartTag().getName()).map(Class::getCanonicalName).map(this.elements::getTypeElement).map(javax.lang.model.element.Element::asType).orElse(null);
    }

    private Optional<Map<String, Class<?>>> getPropertiesForDOMElement(Element element) {
        return DOMElementsUtil.getTypeForElementTag(element.getStartTag().getName()).map(DOMElementsUtil::getElementProperties);
    }

    private void registerMandatoryAttributes(Attributes attributes) {
        Map<String, String> attrs = this.context.getMandatoryAttributes();
        if (!attrs.isEmpty()) {
            for (Map.Entry<String, String> i : attrs.entrySet()) {
                String v = i.getValue();
                if (v == null) {
                    this.outputDocument.insert(attributes.getBegin(), " " + i.getKey() + " ");
                    continue;
                }
                this.outputDocument.insert(attributes.getBegin(), " " + i.getKey() + "\"" + v + "\" ");
            }
        }
    }

    private void processTextNode(Segment textSegment) {
        this.context.setCurrentSegment(textSegment);
        String elementText = textSegment.toString();
        Matcher matcher = VUE_MUSTACHE_PATTERN.matcher(elementText);
        int lastEnd = 0;
        StringBuilder newText = new StringBuilder();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start > 0) {
                newText.append(elementText, lastEnd, start);
            }
            this.currentExpressionReturnType = TypeName.get(String.class);
            String expressionString = elementText.substring(start + 2, end - 2).trim();
            String processedExpression = this.processExpression(expressionString);
            newText.append("{{ ").append(processedExpression).append(" }}");
            lastEnd = end;
        }
        if (lastEnd > 0) {
            newText.append(elementText.substring(lastEnd));
            this.outputDocument.replace(textSegment, newText.toString());
        }
    }

    private void processVModel(Attribute vModelAttribute) {
        String vModelValue = vModelAttribute.getValue();
        VariableInfo vModelDataField = this.context.findRootVariable(vModelValue);
        if (vModelDataField == null) {
            if (vModelValue.contains(".")) {
                this.logger.error("v-model doesn't support dot notation in Vue GWT: \"" + vModelValue + "\". Try using a @Computed with a getter and a setter. Check our documentation on v-model for more information.");
            } else {
                this.logger.error("Couldn't find @Data or @Computed for v-model \"" + vModelValue + "\". V-Model is only supported on @Data and @Computed. Check our documentation on v-model for more information.");
            }
            return;
        }
        String placeHolderVModelValue = GeneratorsNameUtil.markedDataFieldToPlaceHolderField(vModelValue);
        this.outputDocument.replace(vModelAttribute.getValueSegment(), placeHolderVModelValue);
        this.result.addMarkedDataField(vModelDataField);
    }

    private void processSyncProp(Attribute syncPropAttribute) {
        String syncFieldValue = syncPropAttribute.getValue();
        VariableInfo vModelDataField = this.context.findRootVariable(syncFieldValue);
        if (vModelDataField == null) {
            if (syncFieldValue.contains(".")) {
                this.logger.error(".sync doesn't support dot notation in Vue GWT: \"" + syncFieldValue + "\". Try using a @Computed with a getter and a setter. Check our documentation on .sync for more information.");
            } else {
                this.logger.error("Couldn't find @Data or @Computed for .sync \"" + syncFieldValue + "\". V-Model is only supported on @Data and @Computed. Check our documentation on .sync for more information.");
            }
            return;
        }
        String placeHolderSyncValue = GeneratorsNameUtil.markedDataFieldToPlaceHolderField(syncFieldValue);
        this.outputDocument.replace(syncPropAttribute.getValueSegment(), placeHolderSyncValue);
        this.result.addMarkedDataField(vModelDataField);
    }

    private Optional<LocalComponent> getLocalComponentForElement(Element element) {
        String componentName = element.getAttributes().getValue("is");
        if (componentName == null) {
            componentName = element.getStartTag().getName();
        }
        return this.context.getLocalComponent(componentName);
    }

    private boolean isBooleanBinding(Attribute attribute, LocalComponentProp prop) {
        TypeName type = prop.getType();
        if (type.isBoxedPrimitive()) {
            type = type.unbox();
        }
        return type.equals(TypeName.BOOLEAN) && !attribute.hasValue();
    }

    private void validateStringPropBinding(LocalComponentProp localComponentProp) {
        if (localComponentProp.getType().toString().equals(String.class.getCanonicalName())) {
            return;
        }
        this.logger.error("Passing a String to a non String Prop: \"" + localComponentProp.getPropName() + "\". If you want to pass a boolean or an int you should use v-bind. For example: v-bind:my-prop=\"12\" (or using the short syntax, :my-prop=\"12\") instead of my-prop=\"12\".");
    }

    private void validateRequiredProps(LocalComponent localComponent, Set<LocalComponentProp> foundProps) {
        String missingRequiredProps = localComponent.getRequiredProps().stream().filter(prop -> !foundProps.contains(prop)).map(prop -> "\"" + GeneratorsNameUtil.propNameToAttributeName(prop.getPropName()) + "\"").collect(Collectors.joining(","));
        if (!missingRequiredProps.isEmpty()) {
            this.logger.error("Missing required property: " + missingRequiredProps + " on child component \"" + localComponent.getComponentTagName() + "\"");
        }
    }

    private TypeName getExpressionReturnTypeForAttribute(Attribute attribute, Map<String, Class<?>> propertiesTypes) {
        String attributeName = attribute.getKey().toLowerCase();
        if (attributeName.indexOf("@") == 0 || attributeName.indexOf("v-on:") == 0) {
            return TypeName.VOID;
        }
        if ("v-if".equals(attributeName) || "v-show".equals(attributeName)) {
            return TypeName.BOOLEAN;
        }
        if (GeneratorsUtil.isBoundedAttribute(attributeName)) {
            String unboundedAttributeName = GeneratorsUtil.boundedAttributeToAttributeName(attributeName);
            if (unboundedAttributeName.equals("class") || unboundedAttributeName.equals("style")) {
                return TypeName.get(Any.class);
            }
            if (propertiesTypes.containsKey(unboundedAttributeName)) {
                return TypeName.get(propertiesTypes.get(unboundedAttributeName));
            }
        }
        if (this.currentProp != null) {
            return this.currentProp.getType();
        }
        return TypeName.get(Any.class);
    }

    private String processVForValue(String vForValue) {
        VForDefinition vForDef = new VForDefinition(vForValue, this.context, this.logger);
        this.currentExpressionReturnType = vForDef.getInExpressionType();
        String inExpression = this.processExpression(vForDef.getInExpression());
        return vForDef.getVariableDefinition() + " in " + inExpression;
    }

    private String processSlotScopeValue(String value) {
        SlotScopeDefinition slotScopeDefinition = new SlotScopeDefinition(value, this.context, this.logger);
        return slotScopeDefinition.getSlotScopeVariableName();
    }

    private String processExpression(String expressionString) {
        String string = expressionString = expressionString == null ? "" : expressionString.trim();
        if (expressionString.isEmpty()) {
            if (TemplateParser.isAttributeBinding(this.currentAttribute)) {
                this.logger.error("Empty expression in template property binding. If you want to pass an empty string then simply don't use binding: my-attribute=\"\"", this.currentAttribute.toString());
            } else if (TemplateParser.isEventBinding(this.currentAttribute)) {
                this.logger.error("Empty expression in template event binding.", this.currentAttribute.toString());
            } else {
                return "";
            }
        }
        if (expressionString.startsWith("{")) {
            this.logger.error("Object literal syntax are not supported yet in Vue GWT, please use map(e(\"key1\", myValue), e(\"key2\", myValue2 > 5)...) instead. The object returned by map() is a regular Javascript Object (JsObject) with the given key/values.", expressionString);
        }
        if (expressionString.startsWith("[")) {
            this.logger.error("Array literal syntax are not supported yet in Vue GWT, please use array(myValue, myValue2 > 5...) instead. The object returned by array() is a regular Javascript Array (JsArray) with the given values.", expressionString);
        }
        if (this.shouldSkipExpressionProcessing(expressionString)) {
            return expressionString;
        }
        return this.processJavaExpression(expressionString).toTemplateString();
    }

    private boolean shouldSkipExpressionProcessing(String expressionString) {
        return this.currentProp == null && !String.class.getCanonicalName().equals(this.currentExpressionReturnType.toString()) && this.isSimpleVueJsExpression(expressionString);
    }

    private static boolean isAttributeBinding(Attribute attribute) {
        String attributeName = attribute.getKey().toLowerCase();
        return attributeName.startsWith(":") || attributeName.startsWith("v-bind:");
    }

    private static boolean isEventBinding(Attribute attribute) {
        String attributeName = attribute.getKey().toLowerCase();
        return attributeName.startsWith("@") || attributeName.startsWith("v-on:");
    }

    private static boolean isVSlot(Attribute attribute) {
        String attributeName = attribute.getKey().toLowerCase();
        return attributeName.startsWith("v-slot");
    }

    private boolean isSimpleVueJsExpression(String expressionString) {
        String methodName = expressionString;
        if (expressionString.endsWith("()")) {
            methodName = expressionString.substring(0, expressionString.length() - 2);
        }
        return this.context.hasMethod(methodName);
    }

    private TemplateExpression processJavaExpression(String expressionString) {
        Optional maybeExpression = this.javaParser.parseExpression(expressionString).getResult();
        if (!maybeExpression.isPresent()) {
            this.logger.error("Couldn't parse Expression, make sure it is valid Java.", expressionString);
            throw new RuntimeException();
        }
        Expression expression = (Expression)maybeExpression.get();
        this.resolveTypesUsingImports(expression);
        this.resolveStaticMethodsUsingImports(expression);
        this.checkMethodNames(expression);
        LinkedList<VariableInfo> expressionParameters = new LinkedList<VariableInfo>();
        this.findExpressionParameters(expression, expressionParameters);
        if (this.currentProp == null) {
            expression = this.getTypeFromCast(expression);
        }
        expressionString = expression.toString();
        return this.result.addExpression(expressionString, this.currentExpressionReturnType, this.currentProp == null, expressionParameters);
    }

    private Expression getTypeFromCast(Expression expression) {
        if (expression instanceof BinaryExpr) {
            Expression mostLeft = this.getLeftmostExpression(expression);
            if (mostLeft instanceof CastExpr) {
                CastExpr castExpr = (CastExpr)mostLeft;
                this.currentExpressionReturnType = GeneratorsUtil.stringTypeToTypeName(castExpr.getType().toString());
                BinaryExpr parent = (BinaryExpr)mostLeft.getParentNode().get();
                parent.setLeft(castExpr.getExpression());
            }
        } else if (expression instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)expression;
            this.currentExpressionReturnType = GeneratorsUtil.stringTypeToTypeName(castExpr.getType().toString());
            expression = castExpr.getExpression();
        }
        return expression;
    }

    private Expression getLeftmostExpression(Expression expression) {
        if (expression instanceof BinaryExpr) {
            return this.getLeftmostExpression(((BinaryExpr)expression).getLeft());
        }
        return expression;
    }

    private void resolveTypesUsingImports(Expression expression) {
        if (expression instanceof NodeWithType) {
            NodeWithType nodeWithType = (NodeWithType)((Object)expression);
            nodeWithType.setType(this.getQualifiedName((Type)nodeWithType.getType()));
        }
        expression.getChildNodes().stream().filter(Expression.class::isInstance).map(Expression.class::cast).forEach(this::resolveTypesUsingImports);
    }

    private void resolveStaticMethodsUsingImports(Expression expression) {
        if (expression instanceof MethodCallExpr) {
            MethodCallExpr methodCall = (MethodCallExpr)expression;
            String methodName = methodCall.getName().getIdentifier();
            if (!methodCall.getScope().isPresent() && this.context.hasStaticMethod(methodName)) {
                methodCall.setName(this.context.getFullyQualifiedNameForMethodName(methodName));
            }
        }
        expression.getChildNodes().stream().filter(Expression.class::isInstance).map(Expression.class::cast).forEach(this::resolveStaticMethodsUsingImports);
    }

    private void checkMethodNames(Expression expression) {
        String methodName;
        MethodCallExpr methodCall;
        if (expression instanceof MethodCallExpr && !(methodCall = (MethodCallExpr)expression).getScope().isPresent() && !this.context.hasMethod(methodName = methodCall.getName().getIdentifier()) && !this.context.hasStaticMethod(methodName)) {
            this.logger.error("Couldn't find the method \"" + methodName + "\". Make sure it is not private.");
        }
        for (Node node : expression.getChildNodes()) {
            if (!(node instanceof Expression)) continue;
            Expression childExpr = (Expression)node;
            this.checkMethodNames(childExpr);
        }
    }

    private void findExpressionParameters(Expression expression, List<VariableInfo> parameters) {
        if (expression instanceof NameExpr) {
            NameExpr nameExpr = (NameExpr)expression;
            if ("$event".equals(nameExpr.getNameAsString())) {
                this.processEventParameter(expression, nameExpr, parameters);
            } else {
                this.processNameExpression(nameExpr, parameters);
            }
        }
        expression.getChildNodes().stream().filter(Expression.class::isInstance).map(Expression.class::cast).forEach(exp -> this.findExpressionParameters((Expression)exp, parameters));
    }

    private void processEventParameter(Expression expression, NameExpr nameExpr, List<VariableInfo> parameters) {
        Optional<Node> parentNode = nameExpr.getParentNode();
        if (parentNode.isPresent() && parentNode.get() instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)parentNode.get();
            parameters.add(new VariableInfo(castExpr.getType().toString(), "$event"));
        } else {
            this.logger.error("\"$event\" should always be casted to it's intended type. Example: @click=\"doSomething((Event) $event)\".", expression.toString());
        }
    }

    private void processNameExpression(NameExpr nameExpr, List<VariableInfo> parameters) {
        String name = nameExpr.getNameAsString();
        if (this.context.hasImport(name)) {
            nameExpr.setName(this.context.getFullyQualifiedNameForClassName(name));
            return;
        }
        if (this.context.hasStaticProperty(name)) {
            nameExpr.setName(this.context.getFullyQualifiedNameForPropertyName(name));
            return;
        }
        VariableInfo variableInfo = this.context.findVariable(name);
        if (variableInfo == null) {
            this.logger.error("Couldn't find variable/method \"" + name + "\". Make sure you didn't forget the @Data/@Prop annotation.");
        }
        if (variableInfo instanceof LocalVariableInfo) {
            parameters.add(variableInfo);
        } else if (variableInfo instanceof DestructuredPropertyInfo) {
            DestructuredPropertyInfo propertyInfo = (DestructuredPropertyInfo)variableInfo;
            parameters.add(propertyInfo.getDestructuredVariable());
            nameExpr.setName(propertyInfo.getAsDestructuredValue());
        } else if (variableInfo instanceof ComputedVariableInfo) {
            nameExpr.setName(((ComputedVariableInfo)variableInfo).getFieldName());
        }
    }

    private String getQualifiedName(Type type) {
        return this.context.getFullyQualifiedNameForClassName(type.toString());
    }
}

