/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser;

import com.axellience.vuegwt.processors.component.template.parser.context.TemplateParserContext;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import vuegwt.shaded.net.htmlparser.jericho.Logger;

public class TemplateParserLogger
implements Logger {
    private final TemplateParserContext context;
    private final Messager messager;

    TemplateParserLogger(TemplateParserContext context, Messager messager) {
        this.context = context;
        this.messager = messager;
    }

    void error(String message, String expression) {
        this.error(message + " In expression: " + expression);
    }

    @Override
    public void error(String message) {
        if (message.contains("contains attribute name with invalid first character")) {
            return;
        }
        this.printMessage(Diagnostic.Kind.ERROR, message);
    }

    @Override
    public void warn(String message) {
        this.printMessage(Diagnostic.Kind.WARNING, message);
    }

    @Override
    public void info(String message) {
        this.printMessage(Diagnostic.Kind.NOTE, message);
    }

    @Override
    public void debug(String message) {
        this.printMessage(Diagnostic.Kind.OTHER, message);
    }

    public void printMessage(Diagnostic.Kind kind, String message) {
        this.messager.printMessage(kind, "In " + this.context.getTemplateName() + this.getCurrentLineInfo() + ": " + message, this.context.getComponentTypeElement());
    }

    private String getCurrentLineInfo() {
        return this.context.getCurrentLine().map(integer -> " at line " + integer).orElse("");
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }
}

