/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.decl.CSSSelector;
import vuegwt.shaded.com.helger.css.decl.CSSSelectorAttribute;
import vuegwt.shaded.com.helger.css.decl.CSSStyleRule;
import vuegwt.shaded.com.helger.css.decl.CascadingStyleSheet;
import vuegwt.shaded.com.helger.css.decl.ICSSSelectorMember;
import vuegwt.shaded.com.helger.css.decl.visit.CSSVisitor;
import vuegwt.shaded.com.helger.css.decl.visit.DefaultCSSVisitor;
import vuegwt.shaded.com.helger.css.reader.CSSReader;
import vuegwt.shaded.com.helger.css.writer.CSSWriter;
import vuegwt.shaded.com.helger.css.writer.CSSWriterSettings;
import vuegwt.shaded.com.squareup.javapoet.ClassName;

public class TemplateScopedCssParser {
    private final Messager messager;

    public TemplateScopedCssParser(Messager messager) {
        this.messager = messager;
    }

    private static String md5(String s2) {
        return Integer.toHexString(s2.toString().hashCode());
    }

    private String getCssAsString(CascadingStyleSheet css) {
        CSSWriterSettings aSettings = new CSSWriterSettings(ECSSVersion.CSS30, true);
        try {
            CSSWriter aWriter = new CSSWriter(aSettings);
            String rslt = aWriter.getCSSAsString(css);
            return rslt;
        }
        catch (Exception ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            return null;
        }
    }

    public Optional<ScopedCssResult> parse(TypeElement componentTypeElement, String css) {
        if (css == null || css.isEmpty()) {
            return Optional.empty();
        }
        ClassName componentTypeName = ClassName.get(componentTypeElement);
        String md5 = TemplateScopedCssParser.md5(componentTypeName.toString());
        final String datav = "data-v-" + md5;
        CascadingStyleSheet cssSheet = CSSReader.readFromString(css, StandardCharsets.UTF_8, ECSSVersion.CSS30);
        if (cssSheet == null) {
            return Optional.empty();
        }
        CSSVisitor.visitCSS(cssSheet, new DefaultCSSVisitor(){

            @Override
            public void onBeginStyleRule(@Nonnull CSSStyleRule aStyleRule) {
                ICommonsList<CSSSelector> selectors = aStyleRule.getAllSelectors();
                if (selectors != null) {
                    for (CSSSelector sel : selectors) {
                        int vDataPosition = TemplateScopedCssParser.this.getVDataPosition(sel);
                        sel.addMember(vDataPosition, new CSSSelectorAttribute("", datav));
                    }
                }
            }
        });
        LinkedHashMap<String, String> mandatoryAttributes = new LinkedHashMap<String, String>();
        mandatoryAttributes.put(datav, null);
        return Optional.of(new ScopedCssResult(this.getCssAsString(cssSheet), mandatoryAttributes));
    }

    private int getVDataPosition(CSSSelector selector) {
        if (selector.hasMembers()) {
            for (int i = selector.getMemberCount() - 1; i > 0; --i) {
                ICSSSelectorMember member = selector.getMemberAtIndex(i);
                if (this.isPseudoElementOrPseudoClass(member)) continue;
                return i + 1;
            }
        }
        return 1;
    }

    private boolean isPseudoElementOrPseudoClass(ICSSSelectorMember member) {
        return member != null && member.getAsCSSString().startsWith(":");
    }

    public static class ScopedCssResult {
        public final String scopedCss;
        public final Map<String, String> mandatoryAttributes;

        public ScopedCssResult(String scopedCss, Map<String, String> mandatoryAttributes) {
            this.scopedCss = scopedCss;
            this.mandatoryAttributes = mandatoryAttributes;
        }
    }
}

