/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser;

import com.axellience.vuegwt.processors.component.template.parser.TemplateParserLogger;
import com.axellience.vuegwt.processors.component.template.parser.context.TemplateParserContext;
import com.axellience.vuegwt.processors.component.template.parser.variable.LocalVariableInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jsinterop.base.Any;
import vuegwt.shaded.com.squareup.javapoet.TypeName;

public class VForDefinition {
    private final TemplateParserLogger logger;
    private static Pattern VFOR_VARIABLE = Pattern.compile("([^ ]*) ([^ ]*)");
    private static Pattern VFOR_VARIABLE_AND_INDEX = Pattern.compile("\\(([^ ]*) ([^,]*),([^\\)]*)\\)");
    private static Pattern VFOR_VARIABLE_AND_KEY = Pattern.compile("\\(([^ ]*) ([^,]*),([^\\)]*)\\)");
    private static Pattern VFOR_VARIABLE_AND_KEY_AND_INDEX = Pattern.compile("\\(([^ ]*) ([^,]*),([^,]*),([^\\)]*)\\)");
    private final String inExpression;
    private final VForDefinitionType type;
    private LocalVariableInfo loopVariableInfo = null;
    private LocalVariableInfo keyVariableInfo = null;
    private LocalVariableInfo indexVariableInfo = null;

    public VForDefinition(String vForValue, TemplateParserContext context, TemplateParserLogger logger) {
        this.logger = logger;
        String[] splitExpression = this.splitVForExpression(vForValue, context);
        String loopVariablesDefinition = splitExpression[0].trim();
        this.inExpression = splitExpression[1].trim();
        boolean iterateOnObject = this.inExpression.startsWith("(Object)");
        if (!iterateOnObject) {
            this.type = VForDefinitionType.ARRAY_OR_RANGE;
            if (this.vForVariableAndIndex(loopVariablesDefinition, context)) {
                return;
            }
            if (this.vForVariable(loopVariablesDefinition, context)) {
                return;
            }
        } else {
            this.type = VForDefinitionType.OBJECT;
            if (this.vForVariableAndKeyAndIndex(loopVariablesDefinition, context)) {
                return;
            }
            if (this.vForVariableAndKey(loopVariablesDefinition, context)) {
                return;
            }
            if (this.vForVariable(loopVariablesDefinition, context)) {
                return;
            }
        }
        logger.error("Invalid v-for found, they should be in the form: \"Todo todo in myTodos\"", vForValue);
    }

    private boolean vForVariable(String loopVariablesDefinition, TemplateParserContext context) {
        Matcher matcher = VFOR_VARIABLE.matcher(loopVariablesDefinition);
        if (matcher.matches()) {
            this.initLoopVariable(matcher.group(1), matcher.group(2), context);
            this.indexVariableInfo = null;
            return true;
        }
        return false;
    }

    private boolean vForVariableAndIndex(String loopVariablesDefinition, TemplateParserContext context) {
        Matcher matcher = VFOR_VARIABLE_AND_INDEX.matcher(loopVariablesDefinition);
        if (matcher.matches()) {
            this.initLoopVariable(matcher.group(1), matcher.group(2), context);
            this.initIndexVariable(matcher.group(3), context);
            return true;
        }
        return false;
    }

    private boolean vForVariableAndKey(String loopVariablesDefinition, TemplateParserContext context) {
        Matcher matcher = VFOR_VARIABLE_AND_KEY.matcher(loopVariablesDefinition);
        if (matcher.matches()) {
            this.initLoopVariable(matcher.group(1), matcher.group(2), context);
            this.initKeyVariable(matcher.group(3), context);
            return true;
        }
        return false;
    }

    private boolean vForVariableAndKeyAndIndex(String loopVariablesDefinition, TemplateParserContext context) {
        Matcher matcher = VFOR_VARIABLE_AND_KEY_AND_INDEX.matcher(loopVariablesDefinition);
        if (matcher.matches()) {
            this.initLoopVariable(matcher.group(1), matcher.group(2), context);
            this.initKeyVariable(matcher.group(3), context);
            this.initIndexVariable(matcher.group(4), context);
            return true;
        }
        return false;
    }

    private void initLoopVariable(String type, String name, TemplateParserContext context) {
        this.loopVariableInfo = context.addLocalVariable(context.getFullyQualifiedNameForClassName(type.trim()), name.trim());
    }

    private void initIndexVariable(String name, TemplateParserContext context) {
        this.indexVariableInfo = context.addLocalVariable("int", name.trim());
    }

    private void initKeyVariable(String name, TemplateParserContext context) {
        this.keyVariableInfo = context.addLocalVariable("String", name.trim());
    }

    private String[] splitVForExpression(String vForValue, TemplateParserContext context) {
        String[] splitExpression = vForValue.split(" in ");
        if (splitExpression.length != 2) {
            splitExpression = vForValue.split(" of ");
        }
        if (splitExpression.length != 2) {
            this.logger.error("Invalid v-for found, they should be in the form: \"Todo todo in myTodos\"", vForValue);
        }
        return splitExpression;
    }

    public String getInExpression() {
        if (this.type == VForDefinitionType.ARRAY_OR_RANGE) {
            return "VForExpressionUtil.vForExpressionFromJava(" + this.inExpression + ")";
        }
        return this.inExpression;
    }

    public TypeName getInExpressionType() {
        if (this.type == VForDefinitionType.ARRAY_OR_RANGE) {
            return TypeName.get(Any.class);
        }
        return TypeName.get(Object.class);
    }

    public String getVariableDefinition() {
        String variableDefinition = this.loopVariableInfo.getName();
        if (this.keyVariableInfo != null || this.indexVariableInfo != null) {
            variableDefinition = "(" + variableDefinition;
            if (this.keyVariableInfo != null) {
                variableDefinition = variableDefinition + ", " + this.keyVariableInfo.getName();
            }
            if (this.indexVariableInfo != null) {
                variableDefinition = variableDefinition + ", " + this.indexVariableInfo.getName();
            }
            variableDefinition = variableDefinition + ")";
        }
        return variableDefinition;
    }

    private static enum VForDefinitionType {
        OBJECT,
        ARRAY_OR_RANGE;

    }
}

