/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser.context;

import com.axellience.vuegwt.processors.component.template.parser.variable.ComputedVariableInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.DestructuredPropertyInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.LocalVariableInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.VariableInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import vuegwt.shaded.com.squareup.javapoet.TypeName;

class ContextLayer {
    private static final String UNIQUE_LOCAL_VARIABLE_PREFIX = "vg$u";
    private final Map<String, VariableInfo> variables = new HashMap<String, VariableInfo>();
    private final Set<String> methods = new HashSet<String>();
    private int uniqueContextVariableCount;
    private final boolean isVFor;

    ContextLayer(int uniqueContextVariableCount, boolean isVFor) {
        this.uniqueContextVariableCount = uniqueContextVariableCount;
        this.isVFor = isVFor;
    }

    private <T extends VariableInfo> T addVariable(T variableInfo) {
        this.variables.put(variableInfo.getName(), variableInfo);
        return variableInfo;
    }

    VariableInfo addVariable(TypeName type, String name) {
        return this.addVariable(new VariableInfo(type, name));
    }

    VariableInfo addComputedVariable(TypeName type, String computedPropertyName, String fieldName) {
        return this.addVariable(new ComputedVariableInfo(type, computedPropertyName, fieldName));
    }

    LocalVariableInfo addLocalVariable(String type, String templateName) {
        return this.addVariable(new LocalVariableInfo(type, templateName));
    }

    LocalVariableInfo addUniqueLocalVariable(String type) {
        return this.addVariable(new LocalVariableInfo(type, UNIQUE_LOCAL_VARIABLE_PREFIX + this.uniqueContextVariableCount++));
    }

    DestructuredPropertyInfo addDestructuredProperty(String propertyType, String propertyName, LocalVariableInfo destructuredVariable) {
        return this.addVariable(new DestructuredPropertyInfo(propertyType, propertyName, destructuredVariable));
    }

    VariableInfo getVariableInfo(String name) {
        return this.variables.get(name);
    }

    void addMethod(String methodName) {
        this.methods.add(methodName);
    }

    boolean hasMethod(String methodName) {
        return this.methods.contains(methodName);
    }

    int getUniqueContextVariableCount() {
        return this.uniqueContextVariableCount;
    }

    boolean isVFor() {
        return this.isVFor;
    }
}

