/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser.context;

import com.axellience.vuegwt.core.client.tools.JsUtils;
import com.axellience.vuegwt.core.client.tools.VForExpressionUtil;
import com.axellience.vuegwt.processors.component.template.parser.context.ContextLayer;
import com.axellience.vuegwt.processors.component.template.parser.context.localcomponents.LocalComponent;
import com.axellience.vuegwt.processors.component.template.parser.context.localcomponents.LocalComponents;
import com.axellience.vuegwt.processors.component.template.parser.variable.DestructuredPropertyInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.LocalVariableInfo;
import com.axellience.vuegwt.processors.component.template.parser.variable.VariableInfo;
import elemental2.dom.Event;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import vuegwt.shaded.com.squareup.javapoet.TypeName;
import vuegwt.shaded.net.htmlparser.jericho.Segment;

public class TemplateParserContext {
    private final TypeElement componentTypeElement;
    private final LocalComponents localComponents;
    private final ContextLayer rootLayer;
    private final Deque<ContextLayer> contextLayers = new ArrayDeque<ContextLayer>();
    private Map<String, String> classNameToFullyQualifiedName = new HashMap<String, String>();
    private Map<String, String> methodNameToFullyQualifiedName = new HashMap<String, String>();
    private Map<String, String> propertyNameToFullyQualifiedName = new HashMap<String, String>();
    private Segment currentSegment;
    private final Map<String, String> mandatoryAttributes = new HashMap<String, String>();

    public TemplateParserContext(TypeElement componentTypeElement, LocalComponents localComponents) {
        this.componentTypeElement = componentTypeElement;
        this.localComponents = localComponents;
        this.addImport(Event.class.getCanonicalName());
        this.addImport(Math.class.getCanonicalName());
        this.addImport(JsUtils.class.getCanonicalName());
        this.addImport(VForExpressionUtil.class.getCanonicalName());
        this.addStaticImport(JsUtils.class.getCanonicalName() + ".map");
        this.addStaticImport(JsUtils.class.getCanonicalName() + ".e");
        this.addStaticImport(JsUtils.class.getCanonicalName() + ".array");
        this.rootLayer = new ContextLayer(0, false);
        this.rootLayer.addMethod("vue");
        this.contextLayers.add(this.rootLayer);
    }

    public void addRootVariable(TypeName type, String name) {
        this.rootLayer.addVariable(type, name);
    }

    public void addRootComputedProperty(TypeName type, String computedPropertyName, String fieldName) {
        this.rootLayer.addComputedVariable(type, computedPropertyName, fieldName);
    }

    public void addRootMethod(String methodName) {
        this.rootLayer.addMethod(methodName);
    }

    public void addContextLayer(boolean isVFor) {
        this.contextLayers.push(new ContextLayer(this.contextLayers.getFirst().getUniqueContextVariableCount(), isVFor));
    }

    public void popContextLayer() {
        this.contextLayers.pop();
    }

    public LocalVariableInfo addLocalVariable(String typeQualifiedName, String name) {
        return this.contextLayers.getFirst().addLocalVariable(typeQualifiedName, name);
    }

    public DestructuredPropertyInfo addDestructuredProperty(String propertyType, String propertyName, LocalVariableInfo destructuredVariable) {
        return this.contextLayers.getFirst().addDestructuredProperty(propertyType, propertyName, destructuredVariable);
    }

    public LocalVariableInfo addUniqueLocalVariable(String typeQualifiedName) {
        return this.contextLayers.getFirst().addUniqueLocalVariable(typeQualifiedName);
    }

    public VariableInfo findVariable(String name) {
        for (ContextLayer contextLayer : this.contextLayers) {
            VariableInfo variableInfo = contextLayer.getVariableInfo(name);
            if (variableInfo == null) continue;
            return variableInfo;
        }
        return null;
    }

    public VariableInfo findRootVariable(String name) {
        return this.rootLayer.getVariableInfo(name);
    }

    public boolean hasMethod(String name) {
        return this.rootLayer.hasMethod(name);
    }

    public void addImport(String fullyQualifiedName) {
        String[] importSplit = fullyQualifiedName.split("\\.");
        String className = importSplit[importSplit.length - 1];
        this.classNameToFullyQualifiedName.put(className, fullyQualifiedName);
    }

    public String getFullyQualifiedNameForClassName(String className) {
        if (!this.classNameToFullyQualifiedName.containsKey(className)) {
            return className;
        }
        return this.classNameToFullyQualifiedName.get(className);
    }

    public boolean hasImport(String className) {
        return this.classNameToFullyQualifiedName.containsKey(className);
    }

    public void addStaticImport(String fullyQualifiedName) {
        String[] importSplit = fullyQualifiedName.split("\\.");
        String symbolName = importSplit[importSplit.length - 1];
        this.methodNameToFullyQualifiedName.put(symbolName, fullyQualifiedName);
        this.propertyNameToFullyQualifiedName.put(symbolName, fullyQualifiedName);
    }

    public String getFullyQualifiedNameForMethodName(String methodName) {
        if (!this.methodNameToFullyQualifiedName.containsKey(methodName)) {
            return methodName;
        }
        return this.methodNameToFullyQualifiedName.get(methodName);
    }

    public String getFullyQualifiedNameForPropertyName(String propertyName) {
        if (!this.propertyNameToFullyQualifiedName.containsKey(propertyName)) {
            return propertyName;
        }
        return this.propertyNameToFullyQualifiedName.get(propertyName);
    }

    public boolean isInVFor() {
        for (ContextLayer contextLayer : this.contextLayers) {
            if (!contextLayer.isVFor()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStaticMethod(String methodName) {
        return this.methodNameToFullyQualifiedName.containsKey(methodName) || this.methodNameToFullyQualifiedName.containsValue(methodName);
    }

    public boolean hasStaticProperty(String propertyName) {
        return this.methodNameToFullyQualifiedName.containsKey(propertyName) || this.methodNameToFullyQualifiedName.containsValue(propertyName);
    }

    public Optional<Integer> getCurrentLine() {
        if (this.currentSegment == null) {
            return Optional.empty();
        }
        return Optional.of(this.currentSegment.getSource().getRow(this.currentSegment.getBegin()));
    }

    public void setCurrentSegment(Segment currentSegment) {
        this.currentSegment = currentSegment;
    }

    public String getTemplateName() {
        return this.componentTypeElement.getSimpleName().toString() + ".html";
    }

    public Optional<LocalComponent> getLocalComponent(String tagName) {
        return this.localComponents.getLocalComponent(tagName);
    }

    public TypeElement getComponentTypeElement() {
        return this.componentTypeElement;
    }

    public Map<String, String> getMandatoryAttributes() {
        return this.mandatoryAttributes;
    }
}

