/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser.context.localcomponents;

import com.axellience.vuegwt.processors.component.template.parser.context.localcomponents.LocalComponentProp;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import vuegwt.shaded.com.squareup.javapoet.TypeName;

public class LocalComponent {
    private final Map<String, LocalComponentProp> attributeNameToPropMap;
    private final Map<String, LocalComponentProp> propNameToPropMap;
    private final Set<LocalComponentProp> requiredProps;
    private final String componentTagName;
    private final TypeMirror componentType;

    LocalComponent(String componentTagName, TypeMirror componentType) {
        this.componentTagName = componentTagName;
        this.componentType = componentType;
        this.attributeNameToPropMap = new HashMap<String, LocalComponentProp>();
        this.propNameToPropMap = new HashMap<String, LocalComponentProp>();
        this.requiredProps = new HashSet<LocalComponentProp>();
    }

    public void addProp(String propName, TypeName propType, boolean isRequired) {
        String attributeName = GeneratorsNameUtil.propNameToAttributeName(propName);
        LocalComponentProp localComponentProp = new LocalComponentProp(propName, attributeName, propType, isRequired);
        this.attributeNameToPropMap.put(attributeName, localComponentProp);
        this.propNameToPropMap.put(propName, localComponentProp);
        if (isRequired) {
            this.requiredProps.add(localComponentProp);
        }
    }

    private Optional<LocalComponentProp> getProp(String attributeName) {
        if (this.attributeNameToPropMap.containsKey(attributeName)) {
            return Optional.of(this.attributeNameToPropMap.get(attributeName));
        }
        if (this.propNameToPropMap.containsKey(attributeName)) {
            return Optional.of(this.propNameToPropMap.get(attributeName));
        }
        return Optional.empty();
    }

    public Optional<LocalComponentProp> getPropForAttribute(String boundedAttributeName) {
        return this.getProp(GeneratorsUtil.boundedAttributeToAttributeName(boundedAttributeName));
    }

    public Set<LocalComponentProp> getRequiredProps() {
        return this.requiredProps;
    }

    public String getComponentTagName() {
        return this.componentTagName;
    }

    public TypeMirror getComponentType() {
        return this.componentType;
    }
}

