/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser.refs;

import com.axellience.vuegwt.core.client.component.IsVueComponent;
import com.axellience.vuegwt.processors.component.template.parser.refs.RefInfo;
import elemental2.core.JsArray;
import elemental2.dom.Element;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class RefFieldValidator {
    private TypeElement component;
    private Map<String, RefInfo> templateRefsMap;
    private Types types;
    private Elements elements;
    private Messager messager;

    public RefFieldValidator(TypeElement component, Set<RefInfo> templateRefs, ProcessingEnvironment processingEnvironment) {
        this.component = component;
        this.templateRefsMap = new HashMap<String, RefInfo>();
        this.types = processingEnvironment.getTypeUtils();
        this.messager = processingEnvironment.getMessager();
        this.elements = processingEnvironment.getElementUtils();
        for (RefInfo templateRef : templateRefs) {
            this.templateRefsMap.put(templateRef.getName(), templateRef);
        }
    }

    public void validateRefField(VariableElement refField) {
        String fieldName = refField.getSimpleName().toString();
        if (!this.templateRefsMap.containsKey(fieldName)) {
            this.printError("Couldn't find ref attribute in template for @Ref field \"" + fieldName + "\"");
            return;
        }
        RefInfo refInfo = this.templateRefsMap.get(fieldName);
        TypeMirror fieldType = refField.asType();
        if (this.isJsArray(fieldType)) {
            this.validateRefArrayField(fieldName, refInfo, fieldType);
        } else {
            this.validateRefField(fieldName, refInfo, fieldType);
        }
    }

    private void validateRefArrayField(String fieldName, RefInfo refElementInfo, TypeMirror fieldType) {
        TypeMirror elementType = refElementInfo.getElementType();
        if (!refElementInfo.isArray()) {
            this.printError("@Ref field \"" + fieldName + "\", must not be a JsArray as the ref is not used inside a v-for.");
            return;
        }
        TypeMirror jsArrayTypeParameter = this.getJsArrayTypeParameter(fieldType);
        if (!this.isRefValidType(jsArrayTypeParameter)) {
            this.printError("Invalid type for @Ref array \"" + fieldName + "\", must be a JsArray of a type extending elemental2.Element or IsVueComponent.");
            return;
        }
        if (elementType != null && !this.types.isAssignable(elementType, jsArrayTypeParameter)) {
            this.printError("Invalid type for @Ref \"" + fieldName + "\", must be able to assign \"" + elementType.toString() + "\".");
        }
    }

    private void validateRefField(String fieldName, RefInfo refElementInfo, TypeMirror fieldType) {
        TypeMirror elementType = refElementInfo.getElementType();
        if (refElementInfo.isArray()) {
            this.printError("@Ref field \"" + fieldName + "\", must be a JsArray as the ref is used inside a v-for.");
            return;
        }
        if (!this.isRefValidType(fieldType)) {
            this.printError("Invalid type for @Ref \"" + fieldName + "\", type must extend elemental2.Element or IsVueComponent.");
            return;
        }
        if (elementType != null && !this.types.isAssignable(elementType, fieldType)) {
            this.printError("Invalid type for @Ref \"" + fieldName + "\", must be able to assign \"" + elementType.toString() + "\".");
        }
    }

    @Nullable
    private TypeMirror getJsArrayTypeParameter(TypeMirror fieldType) {
        if (!(fieldType instanceof DeclaredType)) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)fieldType;
        if (declaredType.getTypeArguments().isEmpty()) {
            return null;
        }
        return declaredType.getTypeArguments().get(0);
    }

    private boolean isJsArray(TypeMirror fieldType) {
        return this.types.isAssignable(this.types.erasure(fieldType), this.types.erasure(this.elements.getTypeElement(JsArray.class.getCanonicalName()).asType()));
    }

    private boolean isRefValidType(TypeMirror type) {
        return this.types.isAssignable(type, this.elements.getTypeElement(Element.class.getCanonicalName()).asType()) || this.types.isAssignable(type, this.elements.getTypeElement(IsVueComponent.class.getCanonicalName()).asType());
    }

    private void printError(String message) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message + " In VueComponent: " + this.component.getQualifiedName(), this.component);
    }
}

