/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser.result;

import com.axellience.vuegwt.processors.component.template.parser.variable.VariableInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import jsinterop.base.Any;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.TypeName;

public class TemplateExpression {
    private final String id;
    private final String body;
    private final boolean shouldCast;
    private final Integer lineInHtml;
    private final TypeName type;
    private final List<VariableInfo> parameters = new LinkedList<VariableInfo>();

    public TemplateExpression(String id, String body, TypeName type, boolean shouldCast, Collection<VariableInfo> parameters, Integer lineInHtml) {
        this.id = id;
        this.type = type;
        this.body = body;
        this.shouldCast = shouldCast;
        this.lineInHtml = lineInHtml;
        HashSet uniqueParameters = new HashSet();
        parameters.forEach(parameter -> {
            if (uniqueParameters.contains(parameter.getName())) {
                return;
            }
            uniqueParameters.add(parameter.getName());
            this.parameters.add((VariableInfo)parameter);
        });
    }

    public String getId() {
        return this.id;
    }

    public TypeName getType() {
        return this.type;
    }

    public List<VariableInfo> getParameters() {
        return this.parameters;
    }

    public String getBody() {
        return this.body;
    }

    public String toTemplateString() {
        CharSequence[] parametersName = (String[])this.parameters.stream().map(VariableInfo::getName).toArray(String[]::new);
        return this.getId() + "(" + String.join((CharSequence)", ", parametersName) + ")";
    }

    public boolean isReturnVoid() {
        return this.type == TypeName.VOID;
    }

    public boolean isReturnAny() {
        return Any.class.getCanonicalName().equals(this.type.toString());
    }

    public boolean isReturnString() {
        if (!(this.type instanceof ClassName)) {
            return false;
        }
        ClassName className = (ClassName)this.type;
        return className.reflectionName().equals("String") || className.reflectionName().equals(String.class.getCanonicalName());
    }

    public boolean isShouldCast() {
        return this.shouldCast;
    }

    public Integer getLineInHtml() {
        return this.lineInHtml;
    }
}

