/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.template.parser.result;

import com.axellience.vuegwt.processors.component.template.parser.context.TemplateParserContext;
import com.axellience.vuegwt.processors.component.template.parser.refs.RefInfo;
import com.axellience.vuegwt.processors.component.template.parser.result.TemplateExpression;
import com.axellience.vuegwt.processors.component.template.parser.variable.VariableInfo;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import vuegwt.shaded.com.squareup.javapoet.TypeName;

public class TemplateParserResult {
    private String processedTemplate;
    private String scopedCss = "";
    private final List<TemplateExpression> expressions = new LinkedList<TemplateExpression>();
    private final TemplateParserContext context;
    private final String templateName;
    private final Set<VariableInfo> markedDataFields;
    private final Set<RefInfo> refs;

    public TemplateParserResult(TemplateParserContext context) {
        this.context = context;
        this.templateName = context.getTemplateName();
        this.markedDataFields = new HashSet<VariableInfo>();
        this.refs = new HashSet<RefInfo>();
    }

    public void setProcessedTemplate(String processedTemplate) {
        this.processedTemplate = processedTemplate;
    }

    public String getProcessedTemplate() {
        return this.processedTemplate;
    }

    public TemplateExpression addExpression(String expression, TypeName expressionType, boolean shouldCast, List<VariableInfo> parameters) {
        String id = "exp$" + this.expressions.size();
        TemplateExpression templateExpression = new TemplateExpression(id, expression.trim(), expressionType, shouldCast, parameters, this.context.getCurrentLine().orElse(null));
        this.expressions.add(templateExpression);
        return templateExpression;
    }

    public void addMarkedDataField(VariableInfo dataFieldName) {
        this.markedDataFields.add(dataFieldName);
    }

    public void addRef(String name, TypeMirror elementType, boolean isArray) {
        this.refs.add(new RefInfo(name, elementType, isArray));
    }

    public List<TemplateExpression> getExpressions() {
        return this.expressions;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getScopedCss() {
        return this.scopedCss;
    }

    public void setScopedCss(String scopedCss) {
        this.scopedCss = scopedCss;
    }

    public Set<VariableInfo> getMarkedDataFields() {
        return this.markedDataFields;
    }

    public Set<RefInfo> getRefs() {
        return this.refs;
    }
}

