/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.component.validators;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import jsinterop.annotations.JsProperty;

public class CollectionFieldsValidator {
    private final Types types;
    private final TypeMirror setType;
    private final TypeMirror listType;
    private final TypeMirror mapType;
    private final Messager messager;

    public CollectionFieldsValidator(Types types, Elements elements, Messager messager) {
        this.types = types;
        this.setType = types.erasure(elements.getTypeElement(Set.class.getCanonicalName()).asType());
        this.listType = types.erasure(elements.getTypeElement(List.class.getCanonicalName()).asType());
        this.mapType = types.erasure(elements.getTypeElement(Map.class.getCanonicalName()).asType());
        this.messager = messager;
    }

    public void validateComponentDataField(VariableElement dataField) {
        this.validateField(dataField, new HashSet<String>(), dataField.getEnclosingElement(), dataField.getSimpleName().toString());
    }

    public void validateComponentPropField(VariableElement propField) {
        if (this.hasSuppressWarning(propField)) {
            return;
        }
        if (this.isCollectionField(propField)) {
            this.validateCollectionField(propField, propField.getEnclosingElement(), propField.getSimpleName().toString());
        }
    }

    private void validateField(VariableElement field, Set<String> exploredTypes, Element component, String debugPath) {
        TypeMirror fieldType = field.asType();
        if (this.hasSuppressWarning(field)) {
            return;
        }
        if (this.isCollectionField(field)) {
            this.validateCollectionField(field, component, debugPath);
        }
        this.validateType(fieldType, exploredTypes, component, debugPath);
    }

    private void validateType(TypeMirror type, Set<String> exploredTypes, Element component, String debugPath) {
        if (type.getKind() != TypeKind.DECLARED) {
            return;
        }
        DeclaredType declaredType = (DeclaredType)type;
        String fieldTypeQualifiedName = type.toString();
        if (exploredTypes.contains(fieldTypeQualifiedName)) {
            return;
        }
        exploredTypes.add(fieldTypeQualifiedName);
        if (this.isJavaBaseType(type)) {
            return;
        }
        declaredType.getTypeArguments().forEach(typeArgument -> this.validateType((TypeMirror)typeArgument, exploredTypes, component, debugPath + " -> " + typeArgument));
        Element fieldTypeElement = declaredType.asElement();
        if (fieldTypeElement == null) {
            return;
        }
        List<VariableElement> childrenFields = ElementFilter.fieldsIn(fieldTypeElement.getEnclosedElements());
        for (VariableElement childField : childrenFields) {
            this.validateField(childField, exploredTypes, component, debugPath + " -> " + childField.getSimpleName());
        }
    }

    private void validateCollectionField(VariableElement field, Element component, String debugPath) {
        if (!this.hasJsPropertyAnnotation(field)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Java Collections must have the @JsProperty annotation to be observed: " + debugPath + ", please check the Vue GWT doc for Java Collection observation, in Component " + component, field);
        }
        if (!this.isSupportedCollectionField(field)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specific Collection type used as a field type, you should use either Map, Set or List: " + debugPath + ", please check the Vue GWT doc for Java Collection observation, in Component" + component, field);
        }
    }

    private boolean hasSuppressWarning(VariableElement field) {
        SuppressWarnings annotation = field.getAnnotation(SuppressWarnings.class);
        if (annotation == null) {
            return false;
        }
        for (String s2 : annotation.value()) {
            if (!"vue-gwt-collections".equals(s2)) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaBaseType(TypeMirror fieldType) {
        return fieldType.toString().startsWith("java.lang");
    }

    private boolean hasJsPropertyAnnotation(VariableElement field) {
        return field.getAnnotation(JsProperty.class) != null;
    }

    private boolean isCollectionField(VariableElement field) {
        TypeMirror type = this.types.erasure(field.asType());
        return this.types.isAssignable(type, this.listType) || this.types.isAssignable(type, this.setType) || this.types.isAssignable(type, this.mapType);
    }

    private boolean isSupportedCollectionField(VariableElement field) {
        TypeMirror type = this.types.erasure(field.asType());
        return this.types.isSameType(type, this.listType) || this.types.isSameType(type, this.setType) || this.types.isSameType(type, this.mapType);
    }
}

