/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.directive;

import com.axellience.vuegwt.core.client.directive.options.VueDirectiveOptions;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import java.lang.reflect.Type;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import jsinterop.annotations.JsType;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.MethodSpec;
import vuegwt.shaded.com.squareup.javapoet.TypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeSpec;

public class VueDirectiveOptionsGenerator {
    private final Elements elementsUtils;
    private final Filer filer;

    public VueDirectiveOptionsGenerator(ProcessingEnvironment processingEnv) {
        this.elementsUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
    }

    public void generate(TypeElement directiveTypeElement) {
        ClassName optionsClassName = GeneratorsNameUtil.directiveOptionsName(directiveTypeElement);
        TypeSpec.Builder componentClassBuilder = TypeSpec.classBuilder(optionsClassName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).superclass((Type)((Object)VueDirectiveOptions.class)).addAnnotation(JsType.class).addJavadoc("VueComponent Directive Options for directive {@link $S}", directiveTypeElement.getQualifiedName().toString());
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC);
        constructorBuilder.addStatement("this.$L = new $T()", "vuegwt$javaDirectiveInstance", TypeName.get(directiveTypeElement.asType()));
        constructorBuilder.addStatement("this.copyHooks()", new Object[0]);
        componentClassBuilder.addMethod(constructorBuilder.build());
        GeneratorsUtil.toJavaFile(this.filer, componentClassBuilder, optionsClassName, directiveTypeElement);
    }
}

