/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.utils;

import com.axellience.vuegwt.core.annotations.component.Component;
import com.axellience.vuegwt.core.annotations.component.Computed;
import com.axellience.vuegwt.core.annotations.component.PropDefault;
import com.axellience.vuegwt.core.annotations.component.PropValidator;
import com.axellience.vuegwt.core.annotations.component.Watch;
import com.axellience.vuegwt.core.client.component.hooks.HasRender;
import com.axellience.vuegwt.core.client.vue.VueComponentFactory;
import com.axellience.vuegwt.processors.utils.GeneratorsNameUtil;
import com.axellience.vuegwt.processors.utils.GeneratorsUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.ParameterizedTypeName;
import vuegwt.shaded.com.squareup.javapoet.TypeName;

public class ComponentGeneratorsUtil {
    public static List<TypeMirror> getComponentLocalComponents(Elements elementsUtil, TypeElement component) {
        Component componentAnnotation = component.getAnnotation(Component.class);
        try {
            Class[] componentsClass = componentAnnotation.components();
            return Stream.of(componentsClass).map(Class::getCanonicalName).map(elementsUtil::getTypeElement).map(Element::asType).collect(Collectors.toList());
        }
        catch (MirroredTypesException mte) {
            return new LinkedList<TypeMirror>(mte.getTypeMirrors());
        }
    }

    public static List<TypeMirror> getComponentCustomizeOptions(Elements elementsUtil, TypeElement component) {
        Component componentAnnotation = component.getAnnotation(Component.class);
        try {
            Class[] componentsClass = componentAnnotation.customizeOptions();
            return Stream.of(componentsClass).map(Class::getCanonicalName).map(elementsUtil::getTypeElement).map(Element::asType).collect(Collectors.toList());
        }
        catch (MirroredTypesException mte) {
            return new LinkedList<TypeMirror>(mte.getTypeMirrors());
        }
    }

    public static TypeName resolveVariableTypeName(VariableElement variableElement, Messager messager) {
        TypeName typeName;
        if (variableElement.asType().getKind() == TypeKind.ERROR) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Couldn't resolve type " + variableElement.asType() + " for variable " + variableElement + ". If you are trying to inject a ComponentFactory inside a Component, please inject VueComponentFactory<MyComponent> instead.");
        }
        if ((typeName = ClassName.get(variableElement.asType())) instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            if (parameterizedTypeName.rawType.equals(ClassName.get(VueComponentFactory.class))) {
                return GeneratorsNameUtil.componentFactoryName((ClassName)parameterizedTypeName.typeArguments.get(0));
            }
        }
        return typeName;
    }

    public static boolean isMethodVisibleInTemplate(ExecutableElement method) {
        return ComponentGeneratorsUtil.isMethodVisibleInJS(method) && !GeneratorsUtil.hasAnnotation(method, Computed.class) && !GeneratorsUtil.hasAnnotation(method, Watch.class) && !GeneratorsUtil.hasAnnotation(method, PropValidator.class) && !GeneratorsUtil.hasAnnotation(method, PropDefault.class) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public static boolean isFieldVisibleInJS(VariableElement field) {
        return GeneratorsUtil.hasAnnotation(field.getEnclosingElement(), JsType.class) && field.getModifiers().contains((Object)Modifier.PUBLIC) || GeneratorsUtil.hasAnnotation(field, JsProperty.class);
    }

    public static boolean isMethodVisibleInJS(ExecutableElement method) {
        return GeneratorsUtil.hasAnnotation(method.getEnclosingElement(), JsType.class) && method.getModifiers().contains((Object)Modifier.PUBLIC) || GeneratorsUtil.hasAnnotation(method, JsMethod.class);
    }

    public static Optional<TypeElement> getSuperComponentType(TypeElement component) {
        if (TypeName.get(Object.class).equals(TypeName.get(component.getSuperclass()))) {
            return Optional.empty();
        }
        return Optional.of((TypeElement)((DeclaredType)component.getSuperclass()).asElement());
    }

    public static int getSuperComponentCount(TypeElement component) {
        return ComponentGeneratorsUtil.getSuperComponentType(component).map(superComponent -> ComponentGeneratorsUtil.getSuperComponentCount(superComponent) + 1).orElse(0);
    }

    public static boolean hasTemplate(ProcessingEnvironment processingEnvironment, TypeElement component) {
        Component annotation = component.getAnnotation(Component.class);
        if (annotation == null || !annotation.hasTemplate()) {
            return false;
        }
        if (component.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        return !GeneratorsUtil.hasInterface(processingEnvironment, component.asType(), HasRender.class);
    }
}

