/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.utils;

import com.axellience.vuegwt.core.annotations.component.Component;
import com.axellience.vuegwt.core.annotations.component.Emit;
import com.axellience.vuegwt.core.annotations.component.JsComponent;
import com.axellience.vuegwt.processors.utils.MissingComponentAnnotationException;
import javax.inject.Provider;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import vuegwt.shaded.com.google.common.base.CaseFormat;
import vuegwt.shaded.com.squareup.javapoet.ClassName;
import vuegwt.shaded.com.squareup.javapoet.ParameterizedTypeName;

public class GeneratorsNameUtil {
    private static String COMPONENT_EXPOSED_TYPE_SUFFIX = "ExposedType";
    private static String COMPONENT_INJECTED_DEPENDENCIES_SUFFIX = "InjectedDependencies";
    private static String COMPONENT_FACTORY_SUFFIX = "Factory";
    private static String DIRECTIVE_OPTIONS_SUFFIX = "Options";

    public static ClassName componentExposedTypeName(TypeElement component) {
        return GeneratorsNameUtil.nameWithSuffix(component, COMPONENT_EXPOSED_TYPE_SUFFIX);
    }

    public static ClassName componentExposedTypeName(ClassName component) {
        return GeneratorsNameUtil.nameWithSuffix(component, COMPONENT_EXPOSED_TYPE_SUFFIX);
    }

    public static ClassName componentInjectedDependenciesName(TypeElement component) {
        return GeneratorsNameUtil.nameWithSuffix(component, COMPONENT_INJECTED_DEPENDENCIES_SUFFIX);
    }

    public static ClassName componentFactoryName(TypeElement component) {
        return GeneratorsNameUtil.nameWithSuffix(component, COMPONENT_FACTORY_SUFFIX);
    }

    public static ClassName componentFactoryName(TypeMirror component) {
        return GeneratorsNameUtil.nameWithSuffix(component, COMPONENT_FACTORY_SUFFIX);
    }

    public static ClassName componentFactoryName(Class<?> component) {
        return GeneratorsNameUtil.nameWithSuffix(component, COMPONENT_FACTORY_SUFFIX);
    }

    public static ClassName componentFactoryName(ClassName component) {
        return GeneratorsNameUtil.nameWithSuffix(component, COMPONENT_FACTORY_SUFFIX);
    }

    public static ClassName directiveOptionsName(TypeElement directive) {
        return GeneratorsNameUtil.nameWithSuffix(directive, DIRECTIVE_OPTIONS_SUFFIX);
    }

    public static ClassName directiveOptionsName(TypeMirror directive) {
        return GeneratorsNameUtil.nameWithSuffix(directive, DIRECTIVE_OPTIONS_SUFFIX);
    }

    public static ClassName directiveOptionsName(Class<?> directive) {
        return GeneratorsNameUtil.nameWithSuffix(directive, DIRECTIVE_OPTIONS_SUFFIX);
    }

    public static ClassName nameWithSuffix(TypeElement type, String suffix) {
        return GeneratorsNameUtil.nameWithSuffix(type.getQualifiedName().toString(), suffix);
    }

    public static ClassName nameWithSuffix(TypeMirror type, String suffix) {
        return GeneratorsNameUtil.nameWithSuffix(type.toString(), suffix);
    }

    public static ClassName nameWithSuffix(Class<?> type, String suffix) {
        return GeneratorsNameUtil.nameWithSuffix(type.getCanonicalName(), suffix);
    }

    public static ClassName nameWithSuffix(ClassName className, String suffix) {
        return GeneratorsNameUtil.nameWithSuffix(className.reflectionName(), suffix);
    }

    public static ClassName nameWithSuffix(String typeQualifiedName, String suffix) {
        return ClassName.bestGuess(typeQualifiedName + suffix);
    }

    public static ParameterizedTypeName providerOf(ClassName className) {
        return ParameterizedTypeName.get(ClassName.get(Provider.class), className);
    }

    public static String getPackage(TypeElement typeElement) {
        return ClassName.get(typeElement).packageName();
    }

    public static String markedDataFieldToPlaceHolderField(String fieldName) {
        return fieldName + "__vuegwt__markedfield";
    }

    public static String componentToTagName(Element componentElement) throws MissingComponentAnnotationException {
        String annotationNameValue;
        Component componentAnnotation = componentElement.getAnnotation(Component.class);
        JsComponent jsComponentAnnotation = componentElement.getAnnotation(JsComponent.class);
        if (componentAnnotation != null) {
            annotationNameValue = componentAnnotation.name();
        } else if (jsComponentAnnotation != null) {
            annotationNameValue = jsComponentAnnotation.value();
        } else {
            throw new MissingComponentAnnotationException();
        }
        if (!"".equals(annotationNameValue)) {
            return annotationNameValue;
        }
        String componentClassName = componentElement.getSimpleName().toString().replaceAll("Component$", "");
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, componentClassName).toLowerCase();
    }

    public static String directiveToTagName(String directiveClassName) {
        directiveClassName = directiveClassName.replaceAll("Directive$", "");
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, directiveClassName).toLowerCase();
    }

    public static String methodToEventName(ExecutableElement method) {
        Emit emitAnnotation = method.getAnnotation(Emit.class);
        if (!"".equals(emitAnnotation.value())) {
            return emitAnnotation.value();
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, method.getSimpleName().toString()).toLowerCase();
    }

    public static String propNameToAttributeName(String propName) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, propName).toLowerCase();
    }

    public static String computedPropertyNameToFieldName(String computedPropertyName) {
        return "vg$c_" + computedPropertyName;
    }
}

