/*
 * Decompiled with CFR 0.152.
 */
package com.axellience.vuegwt.processors.utils;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class InjectedDependenciesUtil {
    public static List<VariableElement> getInjectedFields(TypeElement component) {
        return ElementFilter.fieldsIn(component.getEnclosedElements()).stream().filter(InjectedDependenciesUtil::hasInjectAnnotation).collect(Collectors.toList());
    }

    public static List<ExecutableElement> getInjectedMethods(TypeElement component) {
        return ElementFilter.methodsIn(component.getEnclosedElements()).stream().filter(InjectedDependenciesUtil::hasInjectAnnotation).collect(Collectors.toList());
    }

    public static boolean hasInjectAnnotation(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationQualifiedName = annotationMirror.getAnnotationType().toString();
            if (annotationQualifiedName.equals(Inject.class.getCanonicalName())) {
                return true;
            }
            if (!annotationQualifiedName.equals("vuegwt.shaded.com.google.inject.Inject")) continue;
            return true;
        }
        return false;
    }
}

