/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.adapter;

import io.bit3.jsass.importer.Import;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Objects;
import vuegwt.shaded.org.apache.commons.lang3.StringUtils;

class NativeImport {
    public final String importPath;
    public final String absolutePath;
    public final String contents;
    public final String sourceMap;
    public final String errorMessage;

    public NativeImport(Import sassImport) {
        URI importUri = sassImport.getImportUri();
        URI absoluteUri = sassImport.getAbsoluteUri();
        String uriString = "";
        if (null != importUri) {
            uriString = "file".equals(importUri.getScheme()) ? new File(importUri).getAbsolutePath() : importUri.toString();
        }
        String absoluteString = "";
        if (null != absoluteUri) {
            absoluteString = "file".equals(absoluteUri.getScheme()) ? new File(absoluteUri).getAbsolutePath() : absoluteUri.toString();
        }
        this.importPath = uriString;
        this.absolutePath = absoluteString;
        this.contents = Objects.toString(sassImport.getContents(), "");
        this.sourceMap = Objects.toString(sassImport.getSourceMap(), "");
        this.errorMessage = "";
    }

    public NativeImport(String importPath, String absolutePath, String contents, String sourceMap) {
        this.importPath = importPath;
        this.absolutePath = absolutePath;
        this.contents = contents;
        this.sourceMap = sourceMap;
        this.errorMessage = "";
    }

    public NativeImport(Throwable throwable) {
        this.importPath = "";
        this.absolutePath = "";
        this.contents = "";
        this.sourceMap = "";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String message = throwable.getMessage();
        if (StringUtils.isNotEmpty(message)) {
            printWriter.append(message).append(System.lineSeparator());
        }
        throwable.printStackTrace(printWriter);
        this.errorMessage = stringWriter.toString();
    }
}

