/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.adapter;

import io.bit3.jsass.adapter.LoaderException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import vuegwt.shaded.org.apache.commons.io.FilenameUtils;
import vuegwt.shaded.org.apache.commons.io.IOUtils;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

final class NativeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NativeLoader.class);
    private static final String OS_WIN = "win";
    private static final String OS_LINUX = "linux";
    private static final String OS_FREEBSD = "freebsd";
    private static final String OS_MAC = "mac";
    private static final String ARCH_ARM = "arm";
    private static final String ARCH_AARCH64 = "aarch64";
    private static final String ARCH_AMD64 = "amd64";
    private static final String ARCH_X86_64 = "x86_64";

    private NativeLoader() {
    }

    static void loadLibrary() {
        try {
            File dir = Files.createTempDirectory("libjsass-", new FileAttribute[0]).toFile();
            dir.deleteOnExit();
            if (System.getProperty("os.name").toLowerCase().startsWith(OS_WIN)) {
                System.load(NativeLoader.saveLibrary(dir, "sass"));
            }
            System.load(NativeLoader.saveLibrary(dir, "jsass"));
        }
        catch (Exception exception) {
            LOG.warn(exception.getMessage(), exception);
            throw new LoaderException(exception);
        }
    }

    private static URL findLibraryResource(String libraryFileName) {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String resourceName = null;
        LOG.trace("Load library \"{}\" for os {}:{}", libraryFileName, osName, osArch);
        if (osName.startsWith(OS_WIN)) {
            resourceName = NativeLoader.determineWindowsLibrary(libraryFileName, osName, osArch);
        } else if (osName.startsWith(OS_LINUX)) {
            resourceName = NativeLoader.determineLinuxLibrary(libraryFileName, osName, osArch);
        } else if (osName.startsWith(OS_FREEBSD)) {
            resourceName = NativeLoader.determineFreebsdLibrary(libraryFileName, osName, osArch);
        } else if (osName.startsWith(OS_MAC)) {
            resourceName = NativeLoader.determineMacLibrary(libraryFileName);
        } else {
            NativeLoader.unsupportedPlatform(osName, osArch);
        }
        URL resource = NativeLoader.class.getResource(resourceName);
        if (null == resource) {
            NativeLoader.unsupportedPlatform(osName, osArch, resourceName);
        }
        return resource;
    }

    private static String determineWindowsLibrary(String library, String osName, String osArch) {
        String platform;
        String fileExtension = "dll";
        switch (osArch) {
            case "amd64": 
            case "x86_64": {
                platform = "windows-x64";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Platform " + osName + ":" + osArch + " not supported");
            }
        }
        String resourceName = "/" + platform + "/" + library + "." + fileExtension;
        return resourceName;
    }

    private static String determineLinuxLibrary(String library, String osName, String osArch) {
        String platform = null;
        String fileExtension = "so";
        switch (osArch) {
            case "amd64": 
            case "x86_64": {
                platform = "linux-x64";
                break;
            }
            case "arm": {
                platform = "linux-armhf32";
                break;
            }
            case "aarch64": {
                platform = "linux-aarch64";
                break;
            }
            default: {
                NativeLoader.unsupportedPlatform(osName, osArch);
            }
        }
        String resourceName = "/" + platform + "/" + library + "." + fileExtension;
        return resourceName;
    }

    private static String determineFreebsdLibrary(String library, String osName, String osArch) {
        String platform = null;
        String fileExtension = "so";
        switch (osArch) {
            case "amd64": 
            case "x86_64": {
                platform = "freebsd-x64";
                break;
            }
            default: {
                NativeLoader.unsupportedPlatform(osName, osArch);
            }
        }
        String resourceName = "/" + platform + "/" + library + "." + fileExtension;
        return resourceName;
    }

    private static String determineMacLibrary(String library) {
        String platform = "darwin";
        String fileExtension = "dylib";
        String resourceName = "/" + platform + "/" + library + "." + fileExtension;
        return resourceName;
    }

    static String saveLibrary(File dir, String libraryName) throws IOException {
        String libraryFileName = "lib" + libraryName;
        URL libraryResource = NativeLoader.findLibraryResource(libraryFileName);
        String basename = FilenameUtils.getName(libraryResource.getPath());
        File file = new File(dir, basename);
        file.deleteOnExit();
        try (InputStream in = libraryResource.openStream();
             FileOutputStream out = new FileOutputStream(file);){
            IOUtils.copy(in, (OutputStream)out);
        }
        LOG.trace("Library \"{}\" copied to \"{}\"", (Object)libraryName, (Object)file.getAbsolutePath());
        return file.getAbsolutePath();
    }

    private static void unsupportedPlatform(String osName, String osArch) {
        throw new UnsupportedOperationException("Platform " + osName + ":" + osArch + " not supported");
    }

    private static void unsupportedPlatform(String osName, String osArch, String resourceName) {
        throw new UnsupportedOperationException("Platform " + osName + ":" + osArch + " not supported", new FileNotFoundException("Resource " + resourceName + " not available"));
    }
}

