/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.importer;

import io.bit3.jsass.context.ImportStack;
import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.ImportException;
import io.bit3.jsass.importer.Importer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;

public class JsassCustomHeaderImporter
implements Importer {
    private final ImportStack importStack;

    public JsassCustomHeaderImporter(ImportStack importStack) {
        this.importStack = importStack;
    }

    @Override
    public Collection<Import> apply(String url, Import previous) {
        LinkedList<Import> list = new LinkedList<Import>();
        list.add(this.createCustomHeaderImport(previous));
        return list;
    }

    private Import createCustomHeaderImport(Import previous) {
        int id = this.importStack.register(previous);
        StringBuilder source = new StringBuilder();
        source.append(String.format("$jsass-void: jsass_import_stack_push(%d) !global;%n", id));
        try {
            return new Import(new URI(previous.getAbsoluteUri() + "/JSASS_CUSTOM.scss"), new URI(previous.getAbsoluteUri() + "/JSASS_CUSTOM.scss"), source.toString());
        }
        catch (URISyntaxException e) {
            throw new ImportException(e);
        }
    }
}

