/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.cache;

import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.CodingStyleguideUnaware;
import vuegwt.shaded.com.helger.commons.annotation.ELockType;
import vuegwt.shaded.com.helger.commons.annotation.MustBeLocked;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.OverrideOnDemand;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.cache.IMutableCache;
import vuegwt.shaded.com.helger.commons.collection.CollectionHelper;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsMap;
import vuegwt.shaded.com.helger.commons.collection.map.SoftHashMap;
import vuegwt.shaded.com.helger.commons.collection.map.SoftLinkedHashMap;
import vuegwt.shaded.com.helger.commons.concurrent.SimpleReadWriteLock;
import vuegwt.shaded.com.helger.commons.functional.IFunction;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.statistics.IMutableStatisticsHandlerCache;
import vuegwt.shaded.com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import vuegwt.shaded.com.helger.commons.statistics.StatisticsManager;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@ThreadSafe
public class Cache<KEYTYPE, VALUETYPE>
implements IMutableCache<KEYTYPE, VALUETYPE> {
    public static final String STATISTICS_PREFIX = "cache:";
    private static final Logger s_aLogger = LoggerFactory.getLogger(Cache.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final IFunction<KEYTYPE, VALUETYPE> m_aCacheValueProvider;
    private final int m_nMaxSize;
    private final String m_sName;
    private final IMutableStatisticsHandlerCache m_aCacheAccessStats;
    private final IMutableStatisticsHandlerCounter m_aCacheRemoveStats;
    private final IMutableStatisticsHandlerCounter m_aCacheClearStats;
    @CodingStyleguideUnaware
    private Map<KEYTYPE, VALUETYPE> m_aCache;

    public Cache(@Nonnull IFunction<KEYTYPE, VALUETYPE> iFunction, int n, @Nonnull @Nonempty String string) {
        this.m_aCacheValueProvider = ValueEnforcer.notNull(iFunction, "CacheValueProvider");
        this.m_nMaxSize = n;
        this.m_sName = ValueEnforcer.notEmpty(string, "CacheName");
        this.m_aCacheAccessStats = StatisticsManager.getCacheHandler(STATISTICS_PREFIX + string + "$access");
        this.m_aCacheRemoveStats = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + string + "$remove");
        this.m_aCacheClearStats = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + string + "$clear");
    }

    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    public final boolean hasMaxSize() {
        return this.m_nMaxSize > 0;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    @ReturnsMutableCopy
    @OverrideOnDemand
    @CodingStyleguideUnaware
    protected ICommonsMap<KEYTYPE, VALUETYPE> createCache() {
        return this.hasMaxSize() ? new SoftLinkedHashMap(this.m_nMaxSize) : new SoftHashMap();
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void putInCacheNotLocked(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "cacheKey");
        ValueEnforcer.notNull(VALUETYPE, "cacheValue");
        if (this.m_aCache == null) {
            this.m_aCache = this.createCache();
            if (this.m_aCache == null) {
                throw new IllegalStateException("No cache created!");
            }
        }
        this.m_aCache.put(KEYTYPE, VALUETYPE);
    }

    protected final void putInCache(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "cacheKey");
        ValueEnforcer.notNull(VALUETYPE, "cacheValue");
        this.m_aRWLock.writeLocked(() -> this.putInCacheNotLocked(KEYTYPE, VALUETYPE));
    }

    @Nullable
    @MustBeLocked(value=ELockType.READ)
    protected final VALUETYPE getFromCacheNoStatsNotLocked(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aCache == null ? null : (VALUETYPE)this.m_aCache.get(KEYTYPE);
    }

    @Nullable
    @OverridingMethodsMustInvokeSuper
    protected final VALUETYPE getFromCacheNoStats(@Nullable KEYTYPE KEYTYPE) {
        return (VALUETYPE)this.m_aRWLock.readLocked(() -> this.getFromCacheNoStatsNotLocked(KEYTYPE));
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public VALUETYPE getFromCache(KEYTYPE KEYTYPE) {
        Object object = this.getFromCacheNoStats(KEYTYPE);
        if (object == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                object = this.getFromCacheNoStatsNotLocked(KEYTYPE);
                if (object == null) {
                    object = this.m_aCacheValueProvider.apply(KEYTYPE);
                    if (object == null) {
                        throw new IllegalStateException("The value to cache was null for key '" + KEYTYPE + "'");
                    }
                    this.putInCacheNotLocked(KEYTYPE, object);
                    this.m_aCacheAccessStats.cacheMiss();
                }
                this.m_aCacheAccessStats.cacheHit();
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
        return object;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange removeFromCache(KEYTYPE KEYTYPE) {
        return this.m_aRWLock.writeLocked(() -> {
            if (this.m_aCache == null || this.m_aCache.remove(KEYTYPE) == null) {
                return EChange.UNCHANGED;
            }
            this.m_aCacheRemoveStats.increment();
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange clearCache() {
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aCache == null || this.m_aCache.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.m_aCache.clear();
            this.m_aCacheClearStats.increment();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Cache '" + this.m_sName + "' was cleared");
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLocked(() -> CollectionHelper.getSize(this.m_aCache));
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLocked(() -> CollectionHelper.isEmpty(this.m_aCache));
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_aRWLock.readLocked(() -> CollectionHelper.isNotEmpty(this.m_aCache));
    }

    public String toString() {
        return new ToStringGenerator(this).append("CacheValueProvider", this.m_aCacheValueProvider).append("Name", this.m_sName).append("MaxSize", this.m_nMaxSize).append("Cache", this.m_aCache).getToString();
    }
}

