/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.callback.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.OverrideOnDemand;
import vuegwt.shaded.com.helger.commons.callback.exception.IExceptionCallback;
import vuegwt.shaded.com.helger.commons.error.level.EErrorLevel;
import vuegwt.shaded.com.helger.commons.error.level.IErrorLevel;
import vuegwt.shaded.com.helger.commons.error.level.IHasErrorLevel;
import vuegwt.shaded.com.helger.commons.exception.mock.IMockException;
import vuegwt.shaded.com.helger.commons.log.LogHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@ThreadSafe
public class LoggingExceptionCallback
implements IExceptionCallback<Throwable>,
IHasErrorLevel {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingExceptionCallback.class);
    private IErrorLevel m_aErrorLevel = EErrorLevel.ERROR;

    @Override
    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Nonnull
    public final LoggingExceptionCallback setErrorLevel(@Nonnull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        return this;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getLogMessage(@Nullable Throwable throwable) {
        if (throwable == null) {
            return "An error occurred";
        }
        return "An exception was thrown";
    }

    @OverrideOnDemand
    protected boolean isLogException(@Nullable Throwable throwable) {
        return !(throwable instanceof IMockException);
    }

    @Override
    public void onException(@Nullable Throwable throwable) {
        String string = this.getLogMessage(throwable);
        boolean bl = this.isLogException(throwable);
        LogHelper.log(s_aLogger, this.m_aErrorLevel, string, bl ? throwable : null);
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

