/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.codec;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.codec.DecodeException;
import vuegwt.shaded.com.helger.commons.codec.IByteArrayStreamDecoder;

public class ASCII85Codec
implements IByteArrayStreamDecoder {
    private static final int BIT1 = 8;
    private static final int BIT2 = 16;
    private static final int BIT3 = 24;
    private static final int ENCODED_MAX = 117;
    private static final int ENCODED_MIN = 33;
    private static final int EIGHTY_FIVE = 85;

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null) {
            return;
        }
        ValueEnforcer.isTrue(n2 >= 4, () -> "Buffer too small: " + n2);
        try {
            int n3;
            int n4 = 0;
            byte[] byArray2 = new byte[5];
            int n5 = n;
            if (byArray[n5] == 60 && byArray[n5 + 1] == 126) {
                n5 += 2;
            }
            while (n5 < n + n2 && (n3 = byArray[n5]) != 126) {
                if (!Character.isWhitespace(n3)) {
                    if (n3 == 122 && n4 == 0) {
                        outputStream.write(0);
                        outputStream.write(0);
                        outputStream.write(0);
                        outputStream.write(0);
                    } else {
                        if (n3 < 33 || n3 > 117) {
                            throw new DecodeException("Illegal character in ASCII85Decode: " + n3);
                        }
                        byArray2[n4] = (byte)(n3 - 33);
                        if (++n4 == 5) {
                            n4 = 0;
                            int n6 = 0;
                            for (int i = 0; i < 5; ++i) {
                                n6 = n6 * 85 + byArray2[i];
                            }
                            outputStream.write((byte)(n6 >> 24));
                            outputStream.write((byte)(n6 >> 16));
                            outputStream.write((byte)(n6 >> 8));
                            outputStream.write((byte)n6);
                        }
                    }
                }
                ++n5;
            }
            switch (n4) {
                case 1: {
                    throw new IllegalStateException("Unexpected end of ASCII85 encoded data!");
                }
                case 2: {
                    n3 = byArray2[0] * 85 * 85 * 85 * 85 + byArray2[1] * 85 * 85 * 85 + 614125 + 7225 + 85;
                    outputStream.write((byte)(n3 >> 24));
                    break;
                }
                case 3: {
                    n3 = byArray2[0] * 85 * 85 * 85 * 85 + byArray2[1] * 85 * 85 * 85 + byArray2[2] * 85 * 85 + 7225 + 85;
                    outputStream.write((byte)(n3 >> 24));
                    outputStream.write((byte)(n3 >> 16));
                    break;
                }
                case 4: {
                    n3 = byArray2[0] * 85 * 85 * 85 * 85 + byArray2[1] * 85 * 85 * 85 + byArray2[2] * 85 * 85 + byArray2[3] * 85 + 85;
                    outputStream.write((byte)(n3 >> 24));
                    outputStream.write((byte)(n3 >> 16));
                    outputStream.write((byte)(n3 >> 8));
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to decode ASCII85", iOException);
        }
    }
}

