/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.codec.DecodeException;
import vuegwt.shaded.com.helger.commons.codec.EncodeException;
import vuegwt.shaded.com.helger.commons.codec.IByteArrayCodec;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import vuegwt.shaded.com.helger.commons.string.StringHelper;

public class Base16Codec
implements IByteArrayCodec {
    @Override
    public int getEncodedLength(int n) {
        return n * 2;
    }

    public void encode(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream) {
        ValueEnforcer.notNull(inputStream, "DecodedInputStream");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                outputStream.write(StringHelper.getHexChar((n & 0xF0) >> 4));
                outputStream.write(StringHelper.getHexChar(n & 0xF));
            }
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to encode Base16", iOException);
        }
    }

    @Override
    public void encode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, n, n2);){
            this.encode(nonBlockingByteArrayInputStream, outputStream);
        }
    }

    @Override
    public int getDecodedLength(int n) {
        return n / 2;
    }

    public void decode(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream) {
        ValueEnforcer.notNull(inputStream, "EncodedInputStream");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                char c = (char)n;
                n = inputStream.read();
                if (n < 0) {
                    throw new DecodeException("Invalid Base16 encoding. Premature end of input");
                }
                char c2 = (char)n;
                int n2 = StringHelper.getHexByte(c, c2);
                if (n2 < 0) {
                    throw new DecodeException("Invalid Base16 encoding for " + c + " and " + c2);
                }
                outputStream.write(n2);
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to decode Base16", iOException);
        }
    }

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null) {
            return;
        }
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, n, n2);){
            this.decode(nonBlockingByteArrayInputStream, outputStream);
        }
    }
}

