/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.codec;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.codec.DecodeException;
import vuegwt.shaded.com.helger.commons.codec.IByteArrayDecoder;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

public class DCTCodec
implements IByteArrayDecoder {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DCTCodec.class);

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getDecoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return DCTCodec.getDecodedDCT(byArray, n, n2);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getDecodedDCT(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        BufferedImage bufferedImage;
        if (byArray == null) {
            return null;
        }
        try {
            bufferedImage = ImageIO.read(new NonBlockingByteArrayInputStream(byArray, n, n2));
            if (bufferedImage == null) {
                throw new DecodeException("Failed to read image");
            }
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Read DCT encoded image with " + n2 + " bytes");
            }
        }
        catch (Throwable throwable) {
            throw new DecodeException("Failed to read image", throwable);
        }
        int n3 = ((Image)bufferedImage).getWidth(null);
        int n4 = ((Image)bufferedImage).getHeight(null);
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, n3, n4, nArray, 0, n3);
        try {
            if (!pixelGrabber.grabPixels()) {
                throw new DecodeException("Failed to grab pixels!");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DecodeException(interruptedException);
        }
        byte[] byArray2 = new byte[nArray.length * 3];
        for (int i = 0; i < nArray.length; ++i) {
            byArray2[i * 3] = (byte)(nArray[i] >> 24 & 0xFF);
            byArray2[i * 3 + 1] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray2[i * 3 + 2] = (byte)(nArray[i] >> 8 & 0xFF);
        }
        return byArray2;
    }
}

