/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.collection;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.collection.ArrayHelper;
import vuegwt.shaded.com.helger.commons.collection.CollectionHelper;
import vuegwt.shaded.com.helger.commons.collection.iterate.ArrayIterator;
import vuegwt.shaded.com.helger.commons.collection.iterate.CombinedIterator;
import vuegwt.shaded.com.helger.commons.collection.iterate.EmptyEnumeration;
import vuegwt.shaded.com.helger.commons.collection.iterate.EmptyIterator;
import vuegwt.shaded.com.helger.commons.collection.iterate.EnumerationFromIterator;
import vuegwt.shaded.com.helger.commons.collection.iterate.IIterableIterator;
import vuegwt.shaded.com.helger.commons.collection.iterate.IterableIteratorFromEnumeration;
import vuegwt.shaded.com.helger.commons.collection.iterate.ReverseListIterator;

public final class IteratorHelper {
    private IteratorHelper() {
    }

    public static boolean isEmpty(@Nullable Iterator<?> iterator) {
        return iterator == null || !iterator.hasNext();
    }

    public static boolean isEmpty(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator == null || !iIterableIterator.hasNext();
    }

    public static boolean isEmpty(@Nullable Enumeration<?> enumeration) {
        return enumeration == null || !enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(@Nullable Iterator<?> iterator) {
        return iterator != null && iterator.hasNext();
    }

    public static boolean isNotEmpty(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator != null && iIterableIterator.hasNext();
    }

    public static boolean isNotEmpty(@Nullable Enumeration<?> enumeration) {
        return enumeration != null && enumeration.hasMoreElements();
    }

    @Nonnegative
    public static int getSize(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator == null ? 0 : IteratorHelper.getSize(iIterableIterator.iterator());
    }

    @Nonnegative
    public static int getSize(@Nullable Iterator<?> iterator) {
        int n = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getSize(@Nullable Enumeration<?> enumeration) {
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
        }
        return n;
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> getIterator(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return new IterableIteratorFromEnumeration<ELEMENTTYPE>(enumeration);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return iterable == null ? new EmptyIterator() : IteratorHelper.getIterator(iterable.iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterator<ELEMENTTYPE> emptyIterator) {
        return emptyIterator == null ? new EmptyIterator() : emptyIterator;
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.isEmpty(ELEMENTTYPEArray) ? new EmptyIterator() : new ArrayIterator<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getReverseIterator(@Nullable List<? extends ELEMENTTYPE> list) {
        if (CollectionHelper.isEmpty(list)) {
            return new EmptyIterator();
        }
        return new ReverseListIterator<ELEMENTTYPE>(list);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getCombinedIterator(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nullable Iterator<? extends ELEMENTTYPE> iterator2) {
        return new CombinedIterator<ELEMENTTYPE>(iterator, iterator2);
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return CollectionHelper.isEmpty(iterable) ? new EmptyEnumeration() : IteratorHelper.getEnumeration(iterable.iterator());
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return IteratorHelper.getEnumeration(IteratorHelper.getIterator(ELEMENTTYPEArray));
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterator<ELEMENTTYPE> iterator) {
        if (iterator == null) {
            return new EmptyEnumeration();
        }
        return new EnumerationFromIterator<ELEMENTTYPE>(iterator);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Enumeration<Map.Entry<KEYTYPE, VALUETYPE>> getEnumeration(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (map == null) {
            return new EmptyEnumeration<Map.Entry<KEYTYPE, VALUETYPE>>();
        }
        return IteratorHelper.getEnumeration(map.entrySet());
    }
}

