/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.collection.map;

import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import vuegwt.shaded.com.helger.commons.annotation.OverrideOnDemand;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsLinkedHashMap;
import vuegwt.shaded.com.helger.commons.collection.map.AbstractSoftMap;
import vuegwt.shaded.com.helger.commons.collection.map.MapEntry;
import vuegwt.shaded.com.helger.commons.functional.IPredicate;

public class SoftLinkedHashMap<K, V>
extends AbstractSoftMap<K, V> {
    private final int m_nMaxSize;

    public SoftLinkedHashMap(@Nonnegative int n) {
        super(new InternalLinkedHashMap(n));
        this.m_nMaxSize = n;
        ((InternalLinkedHashMap)this.m_aSrcMap).m_aFilter = entry -> {
            int n = this.size();
            if (n <= this.m_nMaxSize) {
                return false;
            }
            this.onRemoveEldestEntry(n, (Map.Entry)entry);
            return true;
        };
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnegative int n, @Nonnull Map.Entry<K, V> entry) {
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public SoftLinkedHashMap<K, V> getClone() {
        SoftLinkedHashMap<K, V> softLinkedHashMap = new SoftLinkedHashMap<K, V>(this.m_nMaxSize);
        softLinkedHashMap.putAll(this);
        return softLinkedHashMap;
    }

    private static class InternalLinkedHashMap<K, V>
    extends CommonsLinkedHashMap<K, AbstractSoftMap.SoftValue<K, V>> {
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private IPredicate<? super Map.Entry<K, V>> m_aFilter;

        public InternalLinkedHashMap(@Nonnegative int n) {
            super(n, 0.75f, true);
        }

        @Override
        protected final boolean removeEldestEntry(@Nonnull Map.Entry<K, AbstractSoftMap.SoftValue<K, V>> entry) {
            MapEntry mapEntry = new MapEntry(entry.getKey(), entry.getValue().get());
            return this.m_aFilter.test(mapEntry);
        }
    }
}

