/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.state.EInterrupt;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@Immutable
public final class ExecutorServiceHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ExecutorServiceHelper.class);

    private ExecutorServiceHelper() {
    }

    @Nonnull
    public static EInterrupt waitUntilAllTasksAreFinished(@Nonnull ExecutorService executorService) {
        return ExecutorServiceHelper.waitUntilAllTasksAreFinished(executorService, 1L, TimeUnit.SECONDS);
    }

    @Nonnull
    public static EInterrupt waitUntilAllTasksAreFinished(@Nonnull ExecutorService executorService, @Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        ValueEnforcer.notNull(executorService, "ExecutorService");
        try {
            while (!executorService.awaitTermination(l, timeUnit)) {
            }
        }
        catch (InterruptedException interruptedException) {
            s_aLogger.error("Error waiting for Executor service " + executorService + " to end", interruptedException);
            return EInterrupt.INTERRUPTED;
        }
        return EInterrupt.NOT_INTERRUPTED;
    }

    @Nonnull
    public static EInterrupt shutdownAndWaitUntilAllTasksAreFinished(@Nonnull ExecutorService executorService) {
        return ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished(executorService, 1L, TimeUnit.SECONDS);
    }

    @Nonnull
    public static EInterrupt shutdownAndWaitUntilAllTasksAreFinished(@Nonnull ExecutorService executorService, @Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        ValueEnforcer.notNull(executorService, "ExecutorService");
        if (executorService.isShutdown()) {
            return EInterrupt.NOT_INTERRUPTED;
        }
        executorService.shutdown();
        return ExecutorServiceHelper.waitUntilAllTasksAreFinished(executorService, l, timeUnit);
    }
}

