/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;

public final class NonReentrantLock
extends AbstractQueuedSynchronizer
implements Lock {
    private Thread m_aOwner;

    @Override
    public void lock() {
        this.acquire(1);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.tryAcquireNanos(1, timeUnit.toNanos(l));
    }

    @Override
    public void unlock() {
        this.release(1);
    }

    public boolean isHeldByCurrentThread() {
        return this.isHeldExclusively();
    }

    @Override
    @Nonnull
    public Condition newCondition() {
        return new AbstractQueuedSynchronizer.ConditionObject(this);
    }

    @Override
    protected boolean tryAcquire(int n) {
        if (this.compareAndSetState(0, 1)) {
            this.m_aOwner = Thread.currentThread();
            return true;
        }
        return false;
    }

    @Override
    protected boolean tryRelease(int n) {
        if (Thread.currentThread() != this.m_aOwner) {
            throw new IllegalMonitorStateException();
        }
        this.m_aOwner = null;
        this.setState(0);
        return true;
    }

    @Override
    protected boolean isHeldExclusively() {
        return this.getState() != 0 && this.m_aOwner == Thread.currentThread();
    }
}

