/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.concurrent;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.lang.TimeValue;
import vuegwt.shaded.com.helger.commons.state.ESuccess;

@Immutable
public final class ThreadHelper {
    private ThreadHelper() {
    }

    @Nonnull
    public static ESuccess sleepMinutes(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "Minutes");
        return ThreadHelper.sleep(l * 60000L);
    }

    @Nonnull
    public static ESuccess sleepSeconds(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "Seconds");
        return ThreadHelper.sleep(l * 1000L);
    }

    @Nonnull
    public static ESuccess sleep(@Nonnull TimeValue timeValue) {
        ValueEnforcer.notNull(timeValue, "TimeValue");
        return ThreadHelper.sleep(timeValue.getAsMillis());
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        ValueEnforcer.isGE0(l, "Duration");
        ValueEnforcer.notNull(timeUnit, "TimeUnit");
        return ThreadHelper.sleep(timeUnit.toMillis(l));
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "MilliSeconds");
        try {
            Thread.sleep(l);
            return ESuccess.SUCCESS;
        }
        catch (InterruptedException interruptedException) {
            return ESuccess.FAILURE;
        }
    }
}

