/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.datetime;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.state.ESuccess;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@ThreadSafe
public final class PDTConfig {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDTConfig.class);
    private static ZoneId s_aDefaultZoneId = TimeZone.getDefault().toZoneId();
    private static final PDTConfig s_aInstance = new PDTConfig();

    private PDTConfig() {
    }

    @Nonnull
    public static ESuccess setDefaultDateTimeZoneID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "DateTimeZoneID");
        try {
            ZoneId zoneId = ZoneId.of(string);
            TimeZone timeZone = TimeZone.getTimeZone(zoneId);
            s_aDefaultZoneId = zoneId;
            TimeZone.setDefault(timeZone);
            return ESuccess.SUCCESS;
        }
        catch (DateTimeException dateTimeException) {
            s_aLogger.warn("Unsupported ZoneId '" + string + "'", dateTimeException);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static ZoneId getDefaultZoneId() {
        return s_aDefaultZoneId;
    }

    @Nonnull
    public static ZoneId getUTCZoneId() {
        return ZoneOffset.UTC;
    }

    @Nonnull
    public static TimeZone getDefaultTimeZone() {
        return TimeZone.getDefault();
    }
}

