/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.deadlock;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableObject;
import vuegwt.shaded.com.helger.commons.callback.CallbackList;
import vuegwt.shaded.com.helger.commons.collection.ArrayHelper;
import vuegwt.shaded.com.helger.commons.deadlock.IThreadDeadlockCallback;
import vuegwt.shaded.com.helger.commons.deadlock.ThreadDeadlockInfo;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@NotThreadSafe
public class ThreadDeadlockDetector {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ThreadDeadlockDetector.class);
    private final ThreadMXBean m_aMBean = ManagementFactory.getThreadMXBean();
    private final CallbackList<IThreadDeadlockCallback> m_aCallbacks = new CallbackList();

    public void findDeadlockedThreads() {
        long[] lArray;
        long[] lArray2 = lArray = this.m_aMBean.isSynchronizerUsageSupported() ? this.m_aMBean.findDeadlockedThreads() : this.m_aMBean.findMonitorDeadlockedThreads();
        if (ArrayHelper.isNotEmpty(lArray)) {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            Arrays.sort(lArray);
            ThreadDeadlockInfo[] threadDeadlockInfoArray = new ThreadDeadlockInfo[lArray.length];
            for (int i = 0; i < threadDeadlockInfoArray.length; ++i) {
                ThreadInfo threadInfo = this.m_aMBean.getThreadInfo(lArray[i]);
                Thread thread = null;
                StackTraceElement[] stackTraceElementArray = null;
                for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                    if (entry.getKey().getId() != threadInfo.getThreadId()) continue;
                    thread = entry.getKey();
                    stackTraceElementArray = entry.getValue();
                    break;
                }
                if (thread == null) {
                    throw new IllegalStateException("Deadlocked Thread not found as defined by " + threadInfo.toString());
                }
                threadDeadlockInfoArray[i] = new ThreadDeadlockInfo(threadInfo, thread, stackTraceElementArray);
            }
            if (this.m_aCallbacks.isEmpty()) {
                s_aLogger.warn("Found a deadlock of " + threadDeadlockInfoArray.length + " threads but no callbacks are present!");
            } else {
                this.m_aCallbacks.forEach(iThreadDeadlockCallback -> iThreadDeadlockCallback.onDeadlockDetected(threadDeadlockInfoArray));
            }
        }
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IThreadDeadlockCallback> callbacks() {
        return this.m_aCallbacks;
    }
}

