/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.dimension;

import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.dimension.IHasDimensionInt;
import vuegwt.shaded.com.helger.commons.dimension.IHasDimensionLong;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.math.MathHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@Immutable
public class SizeLong
implements IHasDimensionLong,
Serializable {
    private final long m_nWidth;
    private final long m_nHeight;

    public SizeLong(@Nonnull IHasDimensionInt iHasDimensionInt) {
        this(iHasDimensionInt.getWidth(), iHasDimensionInt.getHeight());
    }

    public SizeLong(@Nonnull IHasDimensionLong iHasDimensionLong) {
        this(iHasDimensionLong.getWidth(), iHasDimensionLong.getHeight());
    }

    public SizeLong(@Nonnegative long l, @Nonnegative long l2) {
        this.m_nWidth = ValueEnforcer.isGE0(l, "Width");
        this.m_nHeight = ValueEnforcer.isGE0(l2, "Height");
    }

    @Override
    @Nonnegative
    public long getWidth() {
        return this.m_nWidth;
    }

    @Override
    @Nonnegative
    public long getHeight() {
        return this.m_nHeight;
    }

    @Nonnull
    @CheckReturnValue
    public SizeLong getBestMatchingSize(@Nonnegative long l, @Nonnegative long l2) {
        ValueEnforcer.isGT0(l, "MaxWidth");
        ValueEnforcer.isGT0(l2, "MaxHeight");
        double d = MathHelper.getDividedDouble(this.m_nWidth, l);
        double d2 = MathHelper.getDividedDouble(this.m_nHeight, l2);
        if (d > d2) {
            if (this.m_nWidth > l) {
                return new SizeLong(l, (long)((double)this.m_nHeight / d));
            }
        } else if (this.m_nHeight > l2) {
            return new SizeLong((long)((double)this.m_nWidth / d2), l2);
        }
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public SizeLong getScaledToWidth(@Nonnegative long l) {
        ValueEnforcer.isGT0(l, "NewWidth");
        if (this.m_nWidth == l) {
            return this;
        }
        double d = MathHelper.getDividedDouble(l, this.m_nWidth);
        return new SizeLong(l, (long)((double)this.m_nHeight * d));
    }

    @Nonnull
    @CheckReturnValue
    public SizeLong getScaledToHeight(@Nonnegative long l) {
        ValueEnforcer.isGT0(l, "NewHeight");
        if (this.m_nHeight == l) {
            return this;
        }
        double d = MathHelper.getDividedDouble(l, this.m_nHeight);
        return new SizeLong((long)((double)this.m_nWidth * d), l);
    }

    @Nonnull
    @CheckReturnValue
    public SizeLong getAdded(@Nonnull IHasDimensionLong iHasDimensionLong) {
        ValueEnforcer.notNull(iHasDimensionLong, "ToAdd");
        return new SizeLong(this.m_nWidth + iHasDimensionLong.getWidth(), this.m_nHeight + iHasDimensionLong.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeLong getSubtracted(@Nonnull IHasDimensionLong iHasDimensionLong) {
        ValueEnforcer.notNull(iHasDimensionLong, "ToSubtract");
        return new SizeLong(this.m_nWidth - iHasDimensionLong.getWidth(), this.m_nHeight - iHasDimensionLong.getHeight());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SizeLong sizeLong = (SizeLong)object;
        return this.m_nWidth == sizeLong.m_nWidth && this.m_nHeight == sizeLong.m_nHeight;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nWidth).append(this.m_nHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_nWidth).append("height", this.m_nHeight).getToString();
    }
}

