/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.email;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.email.EmailAddressHelper;
import vuegwt.shaded.com.helger.commons.email.IEmailAddress;
import vuegwt.shaded.com.helger.commons.equals.EqualsHelper;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@Immutable
public class EmailAddress
implements IEmailAddress {
    private final String m_sAddress;
    private final String m_sPersonal;

    public EmailAddress(@Nonnull IEmailAddress iEmailAddress) {
        this(iEmailAddress.getAddress(), iEmailAddress.getPersonal());
    }

    public EmailAddress(@Nonnull String string) {
        this(string, null);
    }

    public EmailAddress(@Nonnull String string, @Nullable String string2) {
        ValueEnforcer.notNull(string, "EmailAddress");
        ValueEnforcer.isTrue(EmailAddressHelper.isValid(string), () -> "The passed email address '" + string + "' is illegal!");
        this.m_sAddress = EmailAddressHelper.getUnifiedEmailAddress(string);
        this.m_sPersonal = StringHelper.hasNoText(string2) ? null : string2;
    }

    @Override
    @Nonnull
    public String getAddress() {
        return this.m_sAddress;
    }

    @Override
    @Nullable
    public String getPersonal() {
        return this.m_sPersonal;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAddress emailAddress = (EmailAddress)object;
        return this.m_sAddress.equals(emailAddress.m_sAddress) && EqualsHelper.equals(this.m_sPersonal, emailAddress.m_sPersonal);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sAddress).append(this.m_sPersonal).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("address", this.m_sAddress).appendIfNotNull("personal", this.m_sPersonal).getToString();
    }
}

