/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.error;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.error.ErrorTextProvider;
import vuegwt.shaded.com.helger.commons.error.IHasErrorField;
import vuegwt.shaded.com.helger.commons.error.IHasErrorID;
import vuegwt.shaded.com.helger.commons.error.level.IHasErrorLevelComparable;
import vuegwt.shaded.com.helger.commons.error.text.IHasErrorText;
import vuegwt.shaded.com.helger.commons.location.ILocation;
import vuegwt.shaded.com.helger.commons.location.SimpleLocation;

@MustImplementEqualsAndHashcode
public interface IError
extends IHasErrorLevelComparable<IError>,
IHasErrorID,
IHasErrorField {
    @Override
    default public String getErrorID() {
        return null;
    }

    @Override
    @Nullable
    default public String getErrorFieldName() {
        return null;
    }

    @Nonnull
    default public ILocation getErrorLocation() {
        return SimpleLocation.NO_LOCATION;
    }

    default public boolean hasErrorLocation() {
        return this.getErrorLocation().isAnyInformationPresent();
    }

    @Nullable
    default public IHasErrorText getErrorTexts() {
        return null;
    }

    @Nullable
    default public String getErrorText(@Nonnull Locale locale) {
        IHasErrorText iHasErrorText = this.getErrorTexts();
        return iHasErrorText == null ? null : iHasErrorText.getDisplayText(locale);
    }

    @Nullable
    default public Throwable getLinkedException() {
        return null;
    }

    default public boolean hasLinkedException() {
        return this.getLinkedException() != null;
    }

    @Nullable
    default public String getLinkedExceptionMessage() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getMessage();
    }

    @Nullable
    default public StackTraceElement[] getLinkedExceptionStackTrace() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getStackTrace();
    }

    @Nullable
    default public Throwable getLinkedExceptionCause() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getCause();
    }

    @Nonnull
    @Nonempty
    default public String getAsString(@Nonnull Locale locale) {
        return ErrorTextProvider.DEFAULT.getErrorText(this, locale);
    }
}

