/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.error.text;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.ArrayHelper;
import vuegwt.shaded.com.helger.commons.error.text.IHasErrorText;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.commons.text.IHasText;
import vuegwt.shaded.com.helger.commons.text.display.IHasDisplayText;
import vuegwt.shaded.com.helger.commons.text.util.TextHelper;

@Immutable
@MustImplementEqualsAndHashcode
public class DynamicHasErrorTextWithArgs
implements IHasErrorText {
    private final IHasText m_aParentText;
    private final Object[] m_aArgs;

    public DynamicHasErrorTextWithArgs(@Nonnull IHasDisplayText iHasDisplayText, Object ... objectArray) {
        this(iHasDisplayText.getAsHasText(), objectArray);
    }

    public DynamicHasErrorTextWithArgs(@Nonnull IHasText iHasText, Object ... objectArray) {
        this.m_aParentText = ValueEnforcer.notNull(iHasText, "ParentText");
        this.m_aArgs = ValueEnforcer.notEmpty(objectArray, "Arguments");
    }

    @Nonnull
    public IHasText getParentText() {
        return this.m_aParentText;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public Object[] getAllArgs() {
        return ArrayHelper.getCopy(this.m_aArgs);
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        String string = this.m_aParentText.getText(locale);
        return TextHelper.getFormattedText(string, this.m_aArgs);
    }

    @Override
    public boolean isMultiLingual() {
        return true;
    }

    public String toString() {
        return new ToStringGenerator(this).append("parentText", this.m_aParentText).append("args", this.m_aArgs).getToString();
    }
}

