/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.format;

import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.format.AbstractFormatterString;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

public final class FormatterMinLengthAddTrailing
extends AbstractFormatterString {
    private final int m_nMinLength;
    private final char m_cFill;

    public FormatterMinLengthAddTrailing(@Nonnegative int n, char c) {
        ValueEnforcer.isGT0(n, "MinLength");
        this.m_nMinLength = n;
        this.m_cFill = c;
    }

    @Nonnegative
    public int getMinLength() {
        return this.m_nMinLength;
    }

    public char getFillChar() {
        return this.m_cFill;
    }

    @Override
    public String apply(@Nullable Object object) {
        String string = this.getValueAsString(object);
        if (string.length() >= this.m_nMinLength) {
            return string;
        }
        return string + StringHelper.getRepeated(this.m_cFill, this.m_nMinLength - string.length());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatterMinLengthAddTrailing formatterMinLengthAddTrailing = (FormatterMinLengthAddTrailing)object;
        return this.m_nMinLength == formatterMinLengthAddTrailing.m_nMinLength && this.m_cFill == formatterMinLengthAddTrailing.m_cFill;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMinLength).append(this.m_cFill).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("minLength", this.m_nMinLength).append("fill", this.m_cFill).getToString();
    }
}

