/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.format;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.format.AbstractFormatterString;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

public class FormatterStringPrefixAndSuffix
extends AbstractFormatterString {
    private final String m_sPrefix;
    private final String m_sSuffix;

    public FormatterStringPrefixAndSuffix(@Nonnull String string, @Nonnull String string2) {
        this.m_sPrefix = ValueEnforcer.notNull(string, "Prefix");
        this.m_sSuffix = ValueEnforcer.notNull(string2, "Suffix");
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    public String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public String apply(@Nullable Object object) {
        return this.m_sPrefix + this.getValueAsString(object) + this.m_sSuffix;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatterStringPrefixAndSuffix formatterStringPrefixAndSuffix = (FormatterStringPrefixAndSuffix)object;
        return this.m_sPrefix.equals(formatterStringPrefixAndSuffix.m_sPrefix) && this.m_sSuffix.equals(formatterStringPrefixAndSuffix.m_sSuffix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).append(this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Prefix", this.m_sPrefix).append("Suffix", this.m_sSuffix).getToString();
    }

    @Nonnull
    public static FormatterStringPrefixAndSuffix createPrefixOnly(@Nonnull String string) {
        return new FormatterStringPrefixAndSuffix(string, "");
    }

    @Nonnull
    public static FormatterStringPrefixAndSuffix createSuffixOnly(@Nonnull String string) {
        return new FormatterStringPrefixAndSuffix("", string);
    }

    @Nonnull
    public static FormatterStringPrefixAndSuffix createWithBrackets() {
        return new FormatterStringPrefixAndSuffix("[", "]");
    }
}

