/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.hashcode;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import vuegwt.shaded.com.helger.commons.annotation.IsSPIImplementation;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeCalculator;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.hashcode.IHashCodeImplementationRegistrarSPI;
import vuegwt.shaded.com.helger.commons.hashcode.IHashCodeImplementationRegistry;
import vuegwt.shaded.com.helger.commons.io.file.FilenameHelper;
import vuegwt.shaded.org.w3c.dom.Node;
import vuegwt.shaded.org.w3c.dom.NodeList;

@IsSPIImplementation
public final class DefaultHashCodeImplementationRegistrarSPI
implements IHashCodeImplementationRegistrarSPI {
    @Override
    public void registerHashCodeImplementations(@Nonnull IHashCodeImplementationRegistry iHashCodeImplementationRegistry) {
        iHashCodeImplementationRegistry.registerHashCodeImplementation(StringBuffer.class, stringBuffer -> stringBuffer.toString().hashCode());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(StringBuilder.class, stringBuilder -> stringBuilder.toString().hashCode());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Node.class, node -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(node).append(node.getNodeType()).append(node.getNodeName()).append(node.getLocalName()).append(node.getNamespaceURI()).append(node.getPrefix()).append(node.getNodeValue());
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            hashCodeGenerator = hashCodeGenerator.append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(nodeList.item(i));
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicBoolean.class, atomicBoolean -> HashCodeCalculator.append(0, atomicBoolean.get()));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicInteger.class, atomicInteger -> HashCodeCalculator.append(0, atomicInteger.get()));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicLong.class, atomicLong -> HashCodeCalculator.append(0, atomicLong.get()));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(boolean[].class, blArray -> Arrays.hashCode(blArray));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(byte[].class, byArray -> Arrays.hashCode(byArray));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(char[].class, cArray -> Arrays.hashCode(cArray));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(double[].class, dArray -> Arrays.hashCode(dArray));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(float[].class, fArray -> Arrays.hashCode(fArray));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(int[].class, nArray -> Arrays.hashCode(nArray));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(long[].class, lArray -> Arrays.hashCode(lArray));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(short[].class, sArray -> Arrays.hashCode(sArray));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Map.class, map -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(map).append(map.size());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                hashCodeGenerator = hashCodeGenerator.append(entry2.getKey()).append(entry2.getValue());
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Collection.class, collection -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(collection).append(collection.size());
            for (Object e : collection) {
                hashCodeGenerator = hashCodeGenerator.append(e);
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Iterator.class, iterator -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(iterator);
            while (iterator.hasNext()) {
                hashCodeGenerator = hashCodeGenerator.append(iterator.next());
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Enumeration.class, enumeration -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(enumeration);
            while (enumeration.hasMoreElements()) {
                hashCodeGenerator = hashCodeGenerator.append(enumeration.nextElement());
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(File.class, file -> FilenameHelper.getCleanPath(file.getAbsoluteFile()).hashCode());
    }
}

