/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.http;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.datetime.PDTFactory;

@Immutable
public final class CHttp {
    public static final Charset HTTP_CHARSET = StandardCharsets.ISO_8859_1;
    public static final String EOL = "\r\n";
    private static final CHttp s_aInstance = new CHttp();

    private CHttp() {
    }

    @Nonnull
    @Nonempty
    public static String getHttpResponseMessage(int n) {
        String string;
        switch (n) {
            case 100: {
                string = "Continue";
                break;
            }
            case 101: {
                string = "Switching Protocols";
                break;
            }
            case 200: {
                string = "OK";
                break;
            }
            case 201: {
                string = "Created";
                break;
            }
            case 202: {
                string = "Accepted";
                break;
            }
            case 203: {
                string = "Non-Authoritative Information";
                break;
            }
            case 204: {
                string = "No Content";
                break;
            }
            case 205: {
                string = "Reset Content";
                break;
            }
            case 206: {
                string = "Partial Content";
                break;
            }
            case 300: {
                string = "Multiple Choices";
                break;
            }
            case 301: {
                string = "Moved Permanently";
                break;
            }
            case 302: {
                string = "Found";
                break;
            }
            case 303: {
                string = "See Other";
                break;
            }
            case 304: {
                string = "Not Modified";
                break;
            }
            case 305: {
                string = "Use Proxy";
                break;
            }
            case 307: {
                string = "Temporary Redirect";
                break;
            }
            case 400: {
                string = "Bad Request";
                break;
            }
            case 401: {
                string = "Unauthorized";
                break;
            }
            case 402: {
                string = "Payment Required";
                break;
            }
            case 403: {
                string = "Forbidden";
                break;
            }
            case 404: {
                string = "Not Found";
                break;
            }
            case 405: {
                string = "Method Not Allowed";
                break;
            }
            case 406: {
                string = "Not Acceptable";
                break;
            }
            case 407: {
                string = "Proxy Authentication Required";
                break;
            }
            case 408: {
                string = "Request Time-out";
                break;
            }
            case 409: {
                string = "Conflict";
                break;
            }
            case 410: {
                string = "Gone";
                break;
            }
            case 411: {
                string = "Length Required";
                break;
            }
            case 412: {
                string = "Precondition Failed";
                break;
            }
            case 413: {
                string = "Request Entity Too Large";
                break;
            }
            case 414: {
                string = "Request-URI Too Large";
                break;
            }
            case 415: {
                string = "Unsupported Media Type";
                break;
            }
            case 416: {
                string = "Requested range not satisfiable";
                break;
            }
            case 417: {
                string = "Expectation Failed";
                break;
            }
            case 500: {
                string = "Internal Server Error";
                break;
            }
            case 501: {
                string = "Not Implemented";
                break;
            }
            case 502: {
                string = "Bad Gateway";
                break;
            }
            case 503: {
                string = "Service Unavailable";
                break;
            }
            case 504: {
                string = "Gateway Time-out";
                break;
            }
            case 505: {
                string = "HTTP Version not supported";
                break;
            }
            default: {
                string = "Unknown (" + n + ")";
            }
        }
        return string;
    }

    public static long getUnifiedMillis(long l) {
        return l / 1000L * 1000L;
    }

    @Nonnull
    public static LocalDateTime convertMillisToLocalDateTime(long l) {
        return PDTFactory.createLocalDateTime(CHttp.getUnifiedMillis(l));
    }
}

