/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.id.factory;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.id.factory.AbstractPersistingIntIDFactory;
import vuegwt.shaded.com.helger.commons.io.file.FileHelper;
import vuegwt.shaded.com.helger.commons.io.file.SimpleFileIO;
import vuegwt.shaded.com.helger.commons.string.StringParser;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@ThreadSafe
public class FileIntIDFactory
extends AbstractPersistingIntIDFactory {
    @Nonnull
    public static final Charset CHARSET_TO_USE = StandardCharsets.ISO_8859_1;
    @Nonnegative
    public static final int DEFAULT_RESERVE_COUNT = 20;
    @Nonnull
    private final File m_aFile;

    public FileIntIDFactory(@Nonnull File file) {
        this(file, 20);
    }

    public FileIntIDFactory(@Nonnull File file, @Nonnegative int n) {
        super(n);
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.isTrue(FileHelper.canReadAndWriteFile(file), () -> "Cannot read and/or write the file " + file + "!");
        this.m_aFile = file;
    }

    @Nonnull
    public File getFile() {
        return this.m_aFile;
    }

    @Override
    protected final int readAndUpdateIDCounter(@Nonnegative int n) {
        String string = SimpleFileIO.getFileAsString(this.m_aFile, CHARSET_TO_USE);
        int n2 = string != null ? StringParser.parseInt(string.trim(), 0) : 0;
        SimpleFileIO.writeFile(this.m_aFile, Integer.toString(n2 + n), CHARSET_TO_USE);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileIntIDFactory fileIntIDFactory = (FileIntIDFactory)object;
        return this.m_aFile.equals(fileIntIDFactory.m_aFile);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFile).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("file", this.m_aFile).getToString();
    }
}

