/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.id.factory;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.id.factory.ILongIDFactory;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;

@ThreadSafe
public final class MemoryLongIDFactory
implements ILongIDFactory {
    public static final long DEFAULT_START_ID = 10000L;
    private final AtomicLong m_aID;

    public MemoryLongIDFactory() {
        this(10000L);
    }

    public MemoryLongIDFactory(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "StartID");
        this.m_aID = new AtomicLong(l);
    }

    @Override
    public long getNewID() {
        return this.m_aID.getAndIncrement();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MemoryLongIDFactory memoryLongIDFactory = (MemoryLongIDFactory)object;
        return this.m_aID.get() == memoryLongIDFactory.m_aID.get();
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aID.get()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_aID).getToString();
    }
}

