/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vuegwt.shaded.com.helger.commons.id.IHasIntID;
import vuegwt.shaded.com.helger.commons.io.file.EFileIOOperation;
import vuegwt.shaded.com.helger.commons.io.file.FileIOError;
import vuegwt.shaded.com.helger.commons.lang.EnumHelper;
import vuegwt.shaded.com.helger.commons.state.ISuccessIndicator;

public enum EFileIOErrorCode implements ISuccessIndicator,
IHasIntID
{
    NO_ERROR(0),
    OPERATION_FAILED(1),
    SECURITY_ERROR(2),
    SOURCE_DOES_NOT_EXIST(3),
    TARGET_ALREADY_EXISTS(4),
    SOURCE_EQUALS_TARGET(5),
    TARGET_IS_CHILD_OF_SOURCE(6),
    OBJECT_CANNOT_BE_HANDLED(7),
    OBJECT_HAS_NO_PARENT(8),
    SOURCE_NOT_READABLE(9),
    SOURCE_PARENT_NOT_WRITABLE(10),
    TARGET_PARENT_NOT_WRITABLE(11),
    IO_ERROR(12);

    private final int m_nID;

    private EFileIOErrorCode(int n2) {
        this.m_nID = n2;
    }

    @Override
    @Nonnegative
    public int getID() {
        return this.m_nID;
    }

    @Nonnull
    public FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull File file) {
        return new FileIOError(eFileIOOperation, this, file);
    }

    @Nonnull
    public FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull Path path) {
        return new FileIOError(eFileIOOperation, this, path.toFile());
    }

    @Nonnull
    public FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull File file, @Nonnull File file2) {
        if (eFileIOOperation.getParamCount() < 2) {
            throw new IllegalStateException("The operation " + (Object)((Object)eFileIOOperation) + " expects only one parameter!");
        }
        return new FileIOError(eFileIOOperation, this, file, file2);
    }

    @Nonnull
    public FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull Path path, @Nonnull Path path2) {
        if (eFileIOOperation.getParamCount() < 2) {
            throw new IllegalStateException("The operation " + (Object)((Object)eFileIOOperation) + " expects only one parameter!");
        }
        return new FileIOError(eFileIOOperation, this, path.toFile(), path2.toFile());
    }

    @Override
    public boolean isSuccess() {
        return this == NO_ERROR;
    }

    @Nonnull
    public static FileIOError getSecurityAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull SecurityException securityException) {
        return new FileIOError(eFileIOOperation, SECURITY_ERROR, securityException);
    }

    @Nonnull
    public static FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull IOException iOException) {
        return new FileIOError(eFileIOOperation, IO_ERROR, iOException);
    }

    @Nonnull
    public static FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull UncheckedIOException uncheckedIOException) {
        return new FileIOError(eFileIOOperation, IO_ERROR, uncheckedIOException);
    }

    @Nullable
    public static EFileIOErrorCode getFromIDOrNull(int n) {
        return EnumHelper.getFromIDOrNull(EFileIOErrorCode.class, n);
    }
}

